/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.core.index.IndexModel;
import org.eclipse.cdt.internal.ui.CCompletionContributorManager;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class DefaultCEditorTextHover
implements ITextHover {
    protected IEditorPart fEditor;

    public DefaultCEditorTextHover(IEditorPart editor) {
        this.fEditor = editor;
    }

    public String getHoverInfo(ITextViewer viewer, IRegion region) {
        String result = null;
        String expression = null;
        if (this.fEditor == null) {
            return null;
        }
        try {
            expression = viewer.getDocument().get(region.getOffset(), region.getLength());
            expression = expression.trim();
            if (expression.length() == 0) {
                return null;
            }
            IFunctionSummary fs = CCompletionContributorManager.getFunctionInfo(expression);
            if (fs != null) {
                StringBuffer s = new StringBuffer();
                s.append(String.valueOf(expression) + "() - " + fs.getSummary() + "\n\n" + fs.getSynopsis());
                int i = 0;
                while (i < s.length()) {
                    if (s.charAt(i) == '\\' && i + 1 < s.length() && s.charAt(i + 1) == 'n') {
                        s.replace(i, i + 2, "\n");
                    }
                    ++i;
                }
                i = s.length();
                if (i != 0 && s.charAt(i - 1) == '\n') {
                    s.replace(i - 1, i, "");
                }
                return s.toString();
            }
            IndexModel model = IndexModel.getDefault();
            IEditorInput input = this.fEditor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IProject project = ((IFileEditorInput)input).getFile().getProject();
                if (!project.exists()) {
                    throw new CoreException((IStatus)new Status(0, "", 0, "", null));
                }
                IProject[] refs = project.getReferencedProjects();
                ITagEntry[] tags = model.query(project, expression, false, true);
                if (tags == null || tags.length == 0) {
                    int j = 0;
                    while (j < refs.length) {
                        if (refs[j].exists() && (tags = model.query(refs[j], expression, false, true)) != null && tags.length > 0) break;
                        ++j;
                    }
                }
                if (tags != null && tags.length > 0) {
                    ITagEntry selectedTag = this.selectTag(tags);
                    StringBuffer s = new StringBuffer();
                    s.append(String.valueOf(expression) + "() - " + selectedTag.getIFile().getFullPath().toString() + "[" + selectedTag.getLineNumber() + "]");
                    s.append("\n\n" + selectedTag.getPattern());
                    return s.toString();
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {}
        if (expression != null && result != null) {
            return String.valueOf(expression) + " = " + result;
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        Point selectedRange = viewer.getSelectedRange();
        if (selectedRange.x >= 0 && selectedRange.y > 0 && offset >= selectedRange.x && offset <= selectedRange.x + selectedRange.y) {
            return new Region(selectedRange.x, selectedRange.y);
        }
        if (viewer != null) {
            return CWordFinder.findWord(viewer.getDocument(), offset);
        }
        return null;
    }

    private ITagEntry selectTag(ITagEntry[] tags) {
        int i = 0;
        while (i < tags.length) {
            if (tags[i].getKind() == 8) {
                return tags[i];
            }
            ++i;
        }
        i = 0;
        while (i < tags.length) {
            if (tags[i].getKind() == 4) {
                return tags[i];
            }
            ++i;
        }
        return tags[0];
    }
}

