/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class LexicalSortingAction
extends Action {
    private static final String ACTION_NAME = "LexicalSortingAction";
    private static final String DIALOG_STORE_KEY = "LexicalSortingAction.sort";
    private LexicalCSorter fSorter;
    private TreeViewer fTreeViewer;

    public LexicalSortingAction(TreeViewer treeViewer) {
        super(CPlugin.getResourceString("LexicalSortingAction.label"));
        this.setDescription(CPlugin.getResourceString("LexicalSortingAction.description"));
        this.setToolTipText(CPlugin.getResourceString("LexicalSortingAction.tooltip"));
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.alphab_sort_co.gif");
        this.fTreeViewer = treeViewer;
        this.fSorter = new LexicalCSorter();
        boolean checked = CPlugin.getDefault().getDialogSettings().getBoolean(DIALOG_STORE_KEY);
        this.valueChanged(checked, false);
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(boolean on, boolean store) {
        this.setChecked(on);
        this.fTreeViewer.setSorter((ViewerSorter)(on ? this.fSorter : null));
        String key = "LexicalSortingAction.tooltip" + (on ? ".on" : ".off");
        this.setToolTipText(CPlugin.getResourceString(key));
        if (store) {
            CPlugin.getDefault().getDialogSettings().put(DIALOG_STORE_KEY, on);
        }
    }

    private class LexicalCSorter
    extends ViewerSorter {
        LexicalCSorter() {
        }

        public boolean isSorterProperty(Object element, Object property) {
            return true;
        }

        public int category(Object obj) {
            if (obj instanceof ICElement) {
                ICElement elem = (ICElement)obj;
                switch (elem.getElementType()) {
                    case 77: {
                        return 1;
                    }
                    case 72: {
                        return 2;
                    }
                    case 64: {
                        return 3;
                    }
                    case 65: {
                        return 4;
                    }
                    case 66: {
                        return 5;
                    }
                    case 69: {
                        return 6;
                    }
                    case 71: {
                        return 7;
                    }
                }
            }
            return 0;
        }
    }
}

