/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.CommonMkInfo;
import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;

public class OpenIncludeAction
extends Action {
    private static final String PREFIX = "OpenIncludeAction.";
    private static final String DIALOG_TITLE = "OpenIncludeAction.dialog.title";
    private static final String DIALOG_MESSAGE = "OpenIncludeAction.dialog.message";
    private ISelectionProvider fSelectionProvider;

    public OpenIncludeAction(ISelectionProvider provider) {
        super(CPlugin.getResourceString("OpenIncludeAction.label"));
        this.setDescription(CPlugin.getResourceString("OpenIncludeAction.description"));
        this.setToolTipText(CPlugin.getResourceString("OpenIncludeAction.tooltip"));
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.cdt.ui.open_incl.gif");
        this.fSelectionProvider = provider;
    }

    public void run() {
        ICElement include = OpenIncludeAction.getIncludeStatement(this.fSelectionProvider.getSelection());
        if (include == null) {
            return;
        }
        try {
            int nElementsFound;
            IFile fileToOpen;
            IResource res = include.getUnderlyingResource();
            ArrayList filesFound = new ArrayList(4);
            if (res != null) {
                this.findFile((IContainer)res.getProject(), (IPath)new Path(include.getElementName()), filesFound);
            }
            if ((fileToOpen = (nElementsFound = filesFound.size()) == 0 ? null : (nElementsFound == 1 ? (IFile)filesFound.get(0) : this.chooseFile(filesFound))) != null) {
                EditorUtility.openInEditor(fileToOpen);
            } else {
                CommonMkInfo mk = null;
                mk = res != null ? new CommonMkInfo(res.getProject().getLocation()) : new CommonMkInfo();
                IPath[] paths = mk.getIncludePaths();
                IPath includePath = null;
                int i = 0;
                while (i < paths.length) {
                    IPath path;
                    if ((res == null || !paths[i].isPrefixOf(res.getProject().getLocation())) && (path = paths[i].append(include.getElementName())).toFile().exists()) {
                        includePath = path;
                        break;
                    }
                    ++i;
                }
                if (includePath != null) {
                    EditorUtility.openInEditor(includePath);
                }
            }
        }
        catch (CModelException e) {
            CPlugin.log(e.getStatus());
        }
        catch (CoreException e) {
            CPlugin.log(e.getStatus());
        }
    }

    private void findFile(IContainer parent, IPath name, ArrayList res) throws CoreException {
        IResource found = parent.findMember(name);
        if (found != null && found.getType() == 1) {
            res.add(found);
        }
        IResource[] children = parent.members();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IContainer) {
                this.findFile((IContainer)children[i], name, res);
            }
            ++i;
        }
    }

    private IFile chooseFile(ArrayList filesFound) {
        LabelProvider renderer = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    return String.valueOf(file.getName()) + " - " + file.getParent().getFullPath().toString();
                }
                return super.getText(element);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(CPlugin.getActiveWorkbenchShell(), (ILabelProvider)renderer, false, false);
        dialog.setTitle(CPlugin.getResourceString(DIALOG_TITLE));
        dialog.setMessage(CPlugin.getResourceString(DIALOG_MESSAGE));
        dialog.setElements(filesFound);
        if (dialog.open() == 0) {
            return (IFile)dialog.getSelectedElement();
        }
        return null;
    }

    private static ICElement getIncludeStatement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof ICElement && ((ICElement)element).getElementType() == 72) {
            return (ICElement)element;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection selection) {
        return OpenIncludeAction.getIncludeStatement(selection) != null;
    }

    public static String getEditorID(String name) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        if (registry != null) {
            IEditorDescriptor descriptor = registry.getDefaultEditor(name);
            if (descriptor != null) {
                return descriptor.getId();
            }
            return registry.getDefaultEditor().getId();
        }
        return null;
    }
}

