/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Iterator;
import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.editor.IProblemAnnotation;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class OverviewRuler {
    private static final int ALL = -1;
    private static final int COMPILE_WARNING = 0;
    private static final int COMPILE_ERROR = 1;
    private static final int TEMPORARY = 2;
    private static final int UNKNOWN = 4;
    private static final RGB[][] COLORS = new RGB[][]{{new RGB(248, 218, 114), new RGB(139, 109, 7)}, {new RGB(255, 140, 140), new RGB(255, 0, 0)}, {new RGB(240, 230, 230), new RGB(200, 100, 100)}};
    private static final int[] LAYERS;
    private static final int INSET = 2;
    private static final int PROBLEM_HEIGHT_MIN = 4;
    private static boolean PROBLEM_HEIGHT_SCALABLE;
    private IAnnotationModel fModel;
    private ITextViewer fTextViewer;
    private Canvas fCanvas;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private int fWidth;
    private Cursor fHitDetectionCursor;
    private Cursor fLastCursor;

    static {
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 1;
        LAYERS = nArray;
        PROBLEM_HEIGHT_SCALABLE = false;
    }

    public OverviewRuler(int width) {
        this.fWidth = width;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fWidth;
    }

    private int getType(Annotation annotation) {
        if (annotation instanceof IProblemAnnotation) {
            IProblemAnnotation pa = (IProblemAnnotation)annotation;
            if (pa.isTemporaryProblem()) {
                return 2;
            }
            if (pa.isError()) {
                return 1;
            }
            if (pa.isWarning()) {
                return 0;
            }
        }
        return 4;
    }

    public void setModel(IAnnotationModel model) {
        if (model != this.fModel || model != null) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.fModel = model;
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.update();
        }
    }

    public Control createControl(Composite parent, ITextViewer textViewer) {
        this.fTextViewer = textViewer;
        this.fHitDetectionCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.fCanvas = new Canvas(parent, 262144);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (OverviewRuler.this.fTextViewer != null) {
                    OverviewRuler.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                OverviewRuler.this.handleDispose();
                OverviewRuler.this.fTextViewer = null;
            }
        });
        this.fCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                OverviewRuler.this.handleMouseDown(event);
            }
        });
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                OverviewRuler.this.handleMouseMove(event);
            }
        });
        if (this.fTextViewer != null) {
            this.fTextViewer.addTextListener((ITextListener)this.fInternalListener);
        }
        return this.fCanvas;
    }

    private void handleDispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeTextListener((ITextListener)this.fInternalListener);
            this.fTextViewer = null;
        }
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
        if (this.fHitDetectionCursor != null) {
            this.fHitDetectionCursor.dispose();
            this.fHitDetectionCursor = null;
        }
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        try {
            gc.setBackground(this.fCanvas.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            this.doPaint(gc);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            gc.dispose();
            throw throwable;
        }
        Object var4_6 = null;
        gc.dispose();
        dest.drawImage(this.fBuffer, 0, 0);
    }

    private Color getColor(RGB rgb) {
        CTextTools textTools = CPlugin.getDefault().getTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private void doPaint(GC gc) {
        if (this.fTextViewer == null) {
            return;
        }
        Rectangle r = new Rectangle(0, 0, 0, 0);
        int hh = 4;
        IDocument document = this.fTextViewer.getDocument();
        IRegion visible = this.fTextViewer.getVisibleRegion();
        StyledText textWidget = this.fTextViewer.getTextWidget();
        int maxLines = textWidget.getLineCount();
        Point size = this.fCanvas.getSize();
        int writable = maxLines * textWidget.getLineHeight();
        if (size.y > writable) {
            size.y = writable;
        }
        int l = 0;
        while (l < LAYERS.length) {
            FilterIterator e = new FilterIterator(LAYERS[l]);
            Color fill = this.getColor(COLORS[LAYERS[l]][0]);
            Color stroke = this.getColor(COLORS[LAYERS[l]][1]);
            int i = 0;
            while (e.hasNext()) {
                Annotation a = (Annotation)e.next();
                Position p = this.fModel.getPosition(a);
                if (p.overlapsWith(visible.getOffset(), visible.getLength())) {
                    int problemOffset = Math.max(p.getOffset(), visible.getOffset());
                    int problemEnd = Math.min(p.getOffset() + p.getLength(), visible.getOffset() + visible.getLength());
                    int problemLength = problemEnd - problemOffset;
                    try {
                        int numbersOfLines;
                        int startLine = textWidget.getLineAtOffset(problemOffset - visible.getOffset());
                        int yy = startLine * size.y / maxLines;
                        if (PROBLEM_HEIGHT_SCALABLE && (hh = (numbersOfLines = document.getNumberOfLines(problemOffset, problemLength)) * size.y / maxLines) < 4) {
                            hh = 4;
                        }
                        if (fill != null) {
                            gc.setBackground(fill);
                            gc.fillRectangle(2, yy, size.x - 4, hh);
                        }
                        if (stroke != null) {
                            gc.setForeground(stroke);
                            r.x = 2;
                            r.y = yy;
                            r.width = size.x - 4 - 1;
                            r.height = hh;
                            gc.setLineWidth(1);
                            gc.drawRectangle(r);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ++i;
            }
            ++l;
        }
    }

    public void update() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    OverviewRuler.this.redraw();
                }
            });
        }
    }

    private void redraw() {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    private int[] toLineNumbers(int y_coordinate) {
        IRegion visible = this.fTextViewer.getVisibleRegion();
        int lineNumber = 0;
        try {
            lineNumber = this.fTextViewer.getDocument().getLineOfOffset(visible.getOffset());
        }
        catch (BadLocationException badLocationException) {}
        StyledText textWidget = this.fTextViewer.getTextWidget();
        int maxLines = textWidget.getContent().getLineCount();
        Point size = this.fCanvas.getSize();
        int writable = maxLines * textWidget.getLineHeight();
        if (size.y > writable) {
            size.y = writable;
        }
        int[] lines = new int[2];
        int pixel = Math.max(y_coordinate - 1, 0);
        lines[0] = lineNumber + pixel * maxLines / size.y;
        pixel = Math.min(size.y, y_coordinate + 1);
        lines[1] = lineNumber + pixel * maxLines / size.y;
        return lines;
    }

    private Position getProblemPositionAt(int[] lineNumbers) {
        Position found = null;
        try {
            IDocument d = this.fTextViewer.getDocument();
            IRegion line = d.getLineInformation(lineNumbers[0]);
            int start = line.getOffset();
            line = d.getLineInformation(lineNumbers[lineNumbers.length - 1]);
            int end = line.getOffset() + line.getLength();
            FilterIterator e = new FilterIterator(-1);
            while (e.hasNext()) {
                Annotation a = (Annotation)e.next();
                Position p = this.fModel.getPosition(a);
                if (start > p.getOffset() || p.getOffset() >= end || found != null && p.getOffset() >= found.getOffset()) continue;
                found = p;
            }
        }
        catch (BadLocationException badLocationException) {}
        return found;
    }

    private void handleMouseDown(MouseEvent event) {
        if (this.fTextViewer != null) {
            int[] lines = this.toLineNumbers(event.y);
            Position p = this.getProblemPositionAt(lines);
            if (p != null) {
                this.fTextViewer.revealRange(p.getOffset(), p.getLength());
                this.fTextViewer.setSelectedRange(p.getOffset(), p.getLength());
            }
            this.fTextViewer.getTextWidget().setFocus();
        }
    }

    private void handleMouseMove(MouseEvent event) {
        if (this.fTextViewer != null) {
            Cursor cursor;
            int[] lines = this.toLineNumbers(event.y);
            Position p = this.getProblemPositionAt(lines);
            Cursor cursor2 = cursor = p != null ? this.fHitDetectionCursor : null;
            if (cursor != this.fLastCursor) {
                this.fCanvas.setCursor(cursor);
                this.fLastCursor = cursor;
            }
        }
    }

    class InternalListener
    implements ITextListener,
    IAnnotationModelListener {
        InternalListener() {
        }

        public void textChanged(TextEvent e) {
            if (OverviewRuler.this.fTextViewer != null && e.getDocumentEvent() == null && e.getViewerRedrawState()) {
                OverviewRuler.this.redraw();
            }
        }

        public void modelChanged(IAnnotationModel model) {
            OverviewRuler.this.update();
        }
    }

    class FilterIterator
    implements Iterator {
        private Iterator fIterator;
        private int fType;
        private Annotation fNext;

        public FilterIterator(int type) {
            this.fType = type;
            if (OverviewRuler.this.fModel != null) {
                this.fIterator = OverviewRuler.this.fModel.getAnnotationIterator();
                this.skip();
            }
        }

        private void skip() {
            while (this.fIterator.hasNext()) {
                this.fNext = (Annotation)this.fIterator.next();
                int type = OverviewRuler.this.getType(this.fNext);
                if ((this.fType != -1 || type == 4) && this.fType != type) continue;
                return;
            }
            this.fNext = null;
        }

        public boolean hasNext() {
            return this.fNext != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object next() {
            Annotation annotation;
            try {
                annotation = this.fNext;
                Object var1_2 = null;
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                if (OverviewRuler.this.fModel == null) throw throwable;
                this.skip();
                throw throwable;
            }
            if (OverviewRuler.this.fModel == null) return annotation;
            this.skip();
            return annotation;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

