/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SetConditionAction
extends Action {
    private IVerticalRuler fRuler;
    private ITextEditor fTextEditor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SetConditionAction(IVerticalRuler ruler, ITextEditor editor) {
        super("Set condition ...");
        this.fRuler = ruler;
        this.fTextEditor = editor;
    }

    public boolean isBreakpointSet() {
        List markers = this.getMarkers();
        return markers != null && markers.size() > 0;
    }

    protected IResource getResource() {
        IResource resource;
        IEditorInput input = this.fTextEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)input.getAdapter((Class)clazz2);
        }
        return resource;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected IVerticalRuler getVerticalRuler() {
        return this.fRuler;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected List getMarkers() {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (resource != null && model != null) {
            try {
                IMarker[] allMarkers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 0);
                if (allMarkers != null) {
                    int i = 0;
                    while (i < allMarkers.length) {
                        if (this.includesRulerLine(model.getMarkerPosition(allMarkers[i]), document)) {
                            markers.add(allMarkers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException x) {
                this.handleCoreException(x, "SetConditionAction:getMarkers");
            }
        }
        return markers;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
                return markerLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength());
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected void handleCoreException(CoreException exception, String message) {
        ILog log = Platform.getPlugin((String)"org.eclipse.ui").getLog();
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, null));
        }
        log.log(exception.getStatus());
    }

    protected Shell getShell() {
        Shell shell;
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && !(shell = window.getShell()).isDisposed()) {
            return shell;
        }
        return null;
    }

    public void run() {
        try {
            int ignoreCount;
            String condition;
            Object[] markers = this.getMarkers().toArray();
            if (markers.length == 0) {
                return;
            }
            IMarker marker = (IMarker)markers[0];
            Shell shell = this.getShell();
            if (shell == null) {
                return;
            }
            Point location = shell.getDisplay().getCursorLocation();
            BreakpointConditionDialog dialog = new BreakpointConditionDialog(shell, location, condition = marker.getAttribute("condition", ""), ignoreCount = marker.getAttribute("ignoreCount", 0));
            if (dialog.open()) {
                condition = dialog.getCondition();
                marker.setAttribute("condition", (Object)condition);
                ignoreCount = dialog.getIgnoreCount();
                marker.setAttribute("ignoreCount", ignoreCount);
                String message = "";
                if (condition.length() > 0) {
                    message = String.valueOf(message) + "if " + condition + " ";
                }
                if (ignoreCount > 0) {
                    message = String.valueOf(message) + "ignore = " + ignoreCount;
                }
                marker.setAttribute("message", (Object)message);
            }
        }
        catch (CoreException coreException) {}
    }

    class BreakpointConditionDialog {
        Shell fShell;
        String fOldCondition;
        String fCondition;
        String fOldIgnoreCount;
        String fIgnoreCount;
        Button fOkButton;
        Button fCancelButton;
        boolean fIsCanceled = true;
        String fTitle = "Breakpoint condition";

        public BreakpointConditionDialog(Shell parent, Point location, String condition, int ignoreCount) {
            this.fOldCondition = condition;
            this.fCondition = condition;
            this.fIgnoreCount = this.fOldIgnoreCount = String.valueOf(ignoreCount);
            this.fShell = new Shell(parent, 34912);
            this.fShell.setText(this.fTitle);
            this.fShell.setLayout((Layout)new GridLayout());
            this.fShell.setLocation(location);
        }

        private void createControlButtons() {
            Composite composite = new Composite((Composite)this.fShell, 0);
            composite.setLayoutData((Object)new GridData(64));
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            this.fOkButton = new Button(composite, 8);
            this.fOkButton.setText("OK");
            this.fOkButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ BreakpointConditionDialog this$1;
                {
                    this.this$1 = breakpointConditionDialog;
                }

                public void widgetSelected(SelectionEvent event) {
                    try {
                        Integer.parseInt(this.this$1.fIgnoreCount);
                    }
                    catch (NumberFormatException e) {
                        MessageDialog.openError((Shell)this.this$1.fShell, (String)this.this$1.fTitle, (String)("Invalid integer value - " + e.getMessage()));
                        return;
                    }
                    this.this$1.fIsCanceled = false;
                    this.this$1.fShell.close();
                }
            });
            this.fCancelButton = new Button(composite, 8);
            this.fCancelButton.setText("Cancel");
            this.fCancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                private final /* synthetic */ BreakpointConditionDialog this$1;
                {
                    this.this$1 = breakpointConditionDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    this.this$1.fCondition = this.this$1.fOldCondition;
                    this.this$1.fIgnoreCount = this.this$1.fOldIgnoreCount;
                    this.this$1.fShell.close();
                }
            });
            this.fShell.setDefaultButton(this.fOkButton);
        }

        private void createTextWidgets() {
            Composite composite = new Composite((Composite)this.fShell, 0);
            composite.setLayoutData((Object)new GridData(1040));
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 131072);
            label.setText("Enter condition to be evaluated:");
            Text textCondition = new Text(composite, 2048);
            label = new Label(composite, 131072);
            label.setText("Enter the number of times to skip before stopping:");
            Text textIgnoreCount = new Text(composite, 2048);
            GridData condGridData = new GridData();
            condGridData.widthHint = 300;
            textCondition.setLayoutData((Object)condGridData);
            textCondition.setText(this.fCondition);
            this.addTextListener(textCondition, true);
            GridData ignoreGridData = new GridData();
            ignoreGridData.widthHint = 50;
            textIgnoreCount.setLayoutData((Object)ignoreGridData);
            textIgnoreCount.setText(this.fIgnoreCount);
            this.addTextListener(textIgnoreCount, false);
        }

        private void addTextListener(Text text, boolean isCondition) {
            text.addModifyListener(new ModifyListener(this, isCondition, text){
                private final /* synthetic */ boolean val$isCondition;
                private final /* synthetic */ Text val$text;
                private final /* synthetic */ BreakpointConditionDialog this$1;
                {
                    this.this$1 = breakpointConditionDialog;
                    this.val$isCondition = bl;
                    this.val$text = text;
                }

                public void modifyText(ModifyEvent e) {
                    if (this.val$isCondition) {
                        this.this$1.fCondition = this.val$text.getText();
                    } else {
                        this.this$1.fIgnoreCount = this.val$text.getText();
                        this.this$1.fOkButton.setEnabled(this.this$1.fIgnoreCount.length() > 0);
                    }
                }
            });
        }

        public String getCondition() {
            return this.fCondition;
        }

        public int getIgnoreCount() {
            int ret = 0;
            try {
                ret = Integer.parseInt(this.fIgnoreCount);
            }
            catch (NumberFormatException numberFormatException) {}
            return ret;
        }

        public boolean open() {
            this.createTextWidgets();
            this.createControlButtons();
            this.fShell.pack();
            this.fShell.open();
            Display display = this.fShell.getDisplay();
            while (!this.fShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            return !this.fIsCanceled;
        }
    }
}

