/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor.asm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.editor.asm.AsmWordDetector;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordPatternRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class AsmCodeScanner
extends AbstractCScanner {
    private static String[] fgKeywords = new String[]{".set", ".section", ".global", ".extern", ".macro", ".endm", ".if", ".ifdef", ".ifndef", ".else", ".endif", ".include", ".globl", ".text", ".data", ".rodata", ".common", ".debug", ".ctor", ".dtor", ".asciz", ".byte", ".long", ".size", ".align", ".type"};
    private static String[] fgTypes = new String[]{"char", "double", "float", "int", "long", "short", "signed", "unsigned", "void"};
    private static String[] fgTokenProperties = new String[]{"c_keyword", "c_type", "c_string", "c_single_line_comment", "c_default"};
    private VersionedWordRule fVersionedWordRule;

    public AsmCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Token token = this.getToken("c_single_line_comment");
        rules.add(new EndOfLineRule("//", (IToken)token));
        rules.add(new EndOfLineRule("#", (IToken)token));
        token = this.getToken("c_string");
        rules.add(new SingleLineRule("'", "'", (IToken)token, '\\'));
        rules.add(new SingleLineRule("\"", "\"", (IToken)token, '\\'));
        Token other = this.getToken("c_default");
        WordRule labelRule = new WordRule(new AsmWordDetector(false), (IToken)other){
            private StringBuffer fBuffer = new StringBuffer();

            public IToken evaluate(ICharacterScanner scanner) {
                int c = scanner.read();
                if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
                    this.fBuffer.setLength(0);
                    do {
                        this.fBuffer.append((char)c);
                    } while (this.fDetector.isWordPart((char)(c = scanner.read())));
                    if (c != 58) {
                        this.unreadBuffer(scanner);
                        return this.fDefaultToken;
                    }
                    this.fBuffer.append((char)c);
                    IToken token = (IToken)this.fWords.get(":");
                    if (token != null) {
                        return token;
                    }
                    return this.fDefaultToken;
                }
                scanner.unread();
                return Token.UNDEFINED;
            }

            public void addWord(String word, IToken token) {
                this.fWords.put(word, token);
            }

            protected void unreadBuffer(ICharacterScanner scanner) {
                int i = this.fBuffer.length() - 1;
                while (i >= 0) {
                    scanner.unread();
                    --i;
                }
            }
        };
        token = this.getToken("c_type");
        labelRule.addWord(":", (IToken)token);
        rules.add(labelRule);
        WordRule wordRule = new WordRule((IWordDetector)new AsmWordDetector('.'), (IToken)other);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)token);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)token);
            ++i;
        }
        rules.add(wordRule);
        token = this.getToken("c_keyword");
        WordPatternRule regPattern = new WordPatternRule((IWordDetector)new AsmWordDetector('%', '\u0000'), "%", null, (IToken)token);
        rules.add(regPattern);
        this.setDefaultReturnToken((IToken)this.getToken("c_default"));
        return rules;
    }

    public void setRules(IRule[] rules) {
        int i = 0;
        while (i < rules.length) {
            if (rules[i].equals((Object)this.fVersionedWordRule)) break;
            ++i;
        }
        if (i == rules.length) {
            this.fVersionedWordRule = null;
        }
        super.setRules(rules);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return super.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    private static class VersionedWordRule
    extends WordRule {
        private final String fVersion;
        private final boolean fEnable;
        private String fCurrentVersion;

        public VersionedWordRule(IWordDetector detector, String version, boolean enable, String currentVersion) {
            super(detector);
            this.fVersion = version;
            this.fEnable = enable;
            this.fCurrentVersion = currentVersion;
        }

        public void setCurrentVersion(String version) {
            this.fCurrentVersion = version;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            IToken token = super.evaluate(scanner);
            if (this.fEnable) {
                if (this.fCurrentVersion.equals(this.fVersion)) {
                    return token;
                }
                return Token.UNDEFINED;
            }
            if (this.fCurrentVersion.equals(this.fVersion)) {
                return Token.UNDEFINED;
            }
            return token;
        }
    }
}

