/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor.asm;

import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.editor.asm.AsmCodeScanner;
import org.eclipse.cdt.internal.ui.editor.asm.AsmPartitionScanner;
import org.eclipse.cdt.internal.ui.text.util.CColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class AsmTextTools {
    private CColorManager fColorManager;
    private AsmCodeScanner fCodeScanner;
    private AsmPartitionScanner fPartitionScanner;
    private PreferenceListener fPreferenceListener = new PreferenceListener();

    public AsmTextTools(IPreferenceStore store) {
        if (store == null) {
            store = CPlugin.getDefault().getPreferenceStore();
        }
        store.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fColorManager = new CColorManager();
        this.fCodeScanner = new AsmCodeScanner(this.fColorManager, store);
        this.fPartitionScanner = new AsmPartitionScanner();
    }

    public AsmTextTools() {
        this(null);
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fPartitionScanner = null;
        this.fColorManager.dispose();
        this.fColorManager = null;
    }

    public CColorManager getColorManager() {
        return this.fColorManager;
    }

    public RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return this.fPartitionScanner;
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        String[] types = new String[]{"__c_multiline_comment"};
        return new DefaultPartitioner(this.getPartitionScanner(), types);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event);
    }

    protected void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
    }

    private class PreferenceListener
    implements IPropertyChangeListener {
        PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            AsmTextTools.this.adaptToPreferenceChange(event);
        }
    }
}

