/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.makeview;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cdt.core.resources.MakeUtil;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.makeview.MakeTarget;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BuildAction;

public class MakeAction
extends Action {
    static final String PREFIX = "BuildAction.";
    MakeTarget[] targets;
    Shell shell;

    public MakeAction(MakeTarget[] targets, Shell shell, String s) {
        super(s);
        this.shell = shell;
        this.targets = targets;
        this.setToolTipText(PREFIX);
        this.setImageDescriptor(CPluginImages.DESC_BUILD_MENU);
    }

    void saveAllResources() {
        if (!BuildAction.isSaveAllSet()) {
            return;
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        int i = 0;
        while (i < this.targets.length) {
            MakeTarget target = this.targets[i];
            projects.add(target.getResource().getProject());
            ++i;
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i2 = 0;
        while (i2 < windows.length) {
            IWorkbenchPage[] pages = windows[i2].getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorReference[] editorReferences = page.getEditorReferences();
                int k = 0;
                while (k < editorReferences.length) {
                    IFile inputFile;
                    IEditorInput input;
                    IEditorPart editor = editorReferences[k].getEditor(false);
                    if (editor != null && editor.isDirty() && (input = editor.getEditorInput()) instanceof IFileEditorInput && projects.contains((inputFile = ((IFileEditorInput)input).getFile()).getProject())) {
                        page.saveEditor(editor, false);
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
    }

    public void run() {
        try {
            this.saveAllResources();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    boolean bCleanConsole = true;
                    int i = 0;
                    while (i < MakeAction.this.targets.length) {
                        MakeTarget target = MakeAction.this.targets[i];
                        IResource res = target.getResource();
                        IProject project = res.getProject();
                        MakeUtil.setSessionConsoleMode((IResource)project, (boolean)bCleanConsole);
                        try {
                            if (!project.equals((Object)res) || target.isLeaf()) {
                                String dir = res.getLocation().toOSString();
                                MakeUtil.setSessionBuildDir((IResource)project, (String)dir);
                                if (target.isLeaf()) {
                                    MakeUtil.setSessionTarget((IResource)project, (String)target.toString());
                                }
                            }
                            project.build(10, monitor);
                        }
                        catch (CoreException coreException) {}
                        MakeUtil.removeSessionBuildDir((IResource)project);
                        MakeUtil.removeSessionTarget((IResource)project);
                        MakeUtil.setSessionConsoleMode((IResource)project, (boolean)true);
                        bCleanConsole = false;
                        ++i;
                    }
                }
            };
            new ProgressMonitorDialog(this.shell).run(true, true, op);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }
}

