/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.dialogs.IStatusChangeListener;
import org.eclipse.cdt.internal.ui.dialogs.StatusTool;
import org.eclipse.cdt.ui.wizards.ReferenceBlock;
import org.eclipse.cdt.ui.wizards.SettingsBlock;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.cdt.utils.ui.swt.IValidation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class CProjectPropertyPage
extends PropertyPage
implements IStatusChangeListener,
IValidation {
    private static final String MSG_NOCPROJECT = "CProjectPropertyPage.nocproject";
    private static final String MSG_CLOSEDPROJECT = "CProjectPropertyPage.closedproject";
    private TabFolder folder;
    ReferenceBlock referenceBlock;
    SettingsBlock settingsBlock;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        IProject project = this.getProject();
        if (!project.isOpen()) {
            this.contentForClosedProject(composite);
        } else {
            this.contentForCProject(composite);
        }
        return composite;
    }

    private void contentForCProject(Composite parent) {
        this.folder = new TabFolder(parent, 0);
        this.folder.setLayout((Layout)new TabFolderLayout());
        this.referenceBlock = new ReferenceBlock(this, this.getProject());
        TabItem item = new TabItem(this.folder, 0);
        item.setText(this.referenceBlock.getLabel());
        Image img = this.referenceBlock.getImage();
        if (img != null) {
            item.setImage(img);
        }
        item.setData((Object)this.referenceBlock);
        item.setControl((Control)this.referenceBlock.getControl((Composite)this.folder));
        this.settingsBlock = new SettingsBlock(this, this.getProject());
        TabItem item2 = new TabItem(this.folder, 0);
        item2.setText(this.settingsBlock.getLabel());
        Image img2 = this.settingsBlock.getImage();
        if (img2 != null) {
            item2.setImage(img2);
        }
        item2.setData((Object)this.settingsBlock);
        item2.setControl((Control)this.settingsBlock.getControl((Composite)this.folder));
        WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.cdt.ui.new_project_property_page_context");
    }

    private void contentForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(CPlugin.getResourceString(MSG_CLOSEDPROJECT));
        label.setFont(parent.getFont());
        this.noDefaultAndApplyButton();
    }

    public void setComplete(boolean complete) {
        boolean ok = true;
        if (this.referenceBlock != null) {
            ok = this.referenceBlock.isValid();
        }
        if (ok && this.settingsBlock != null) {
            ok = this.settingsBlock.isValid();
        }
        this.setValid(ok);
    }

    public boolean performOk() {
        if (this.settingsBlock != null) {
            this.settingsBlock.doRun(this.getProject(), null);
        }
        if (this.referenceBlock != null) {
            this.referenceBlock.doRun(this.getProject(), null);
        }
        return true;
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)element;
        }
        return null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.folder != null) {
            this.settingsBlock.setVisible(visible);
            this.referenceBlock.setVisible(visible);
            this.folder.setFocus();
        }
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusTool.applyToStatusLine((DialogPage)this, status);
    }
}

