/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.text.LineBreakingReader;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class CAnnotationHover
implements IAnnotationHover {
    protected int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                if (line == markerLine) {
                    return 1;
                }
                if (markerLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                    return 2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    protected IMarker select(List firstChoice, List secondChoice) {
        if (!firstChoice.isEmpty()) {
            return (IMarker)firstChoice.get(0);
        }
        if (!secondChoice.isEmpty()) {
            return (IMarker)secondChoice.get(0);
        }
        return null;
    }

    protected IMarker getMarker(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<IMarker> exact = new ArrayList<IMarker>();
        ArrayList<IMarker> including = new ArrayList<IMarker>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object o = e.next();
            if (!(o instanceof MarkerAnnotation)) continue;
            MarkerAnnotation a = (MarkerAnnotation)o;
            switch (this.compareRulerLine(model.getPosition((Annotation)a), document, line)) {
                case 1: {
                    exact.add(a.getMarker());
                    break;
                }
                case 2: {
                    including.add(a.getMarker());
                }
            }
        }
        return this.select(exact, including);
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        String text;
        IMarker marker = this.getMarker(sourceViewer, lineNumber);
        if (marker != null && (text = marker.getAttribute("message", null)) != null) {
            return this.formatHoverText(text, sourceViewer.getTextWidget().getDisplay());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String formatHoverText(String text, Display display) {
        GC gc;
        block8: {
            String string;
            String lineDelim = System.getProperty("line.separator", "\n");
            StringReader textReader = new StringReader(text);
            gc = new GC((Drawable)display);
            try {
                try {
                    StringBuffer buf = new StringBuffer();
                    LineBreakingReader reader = new LineBreakingReader(textReader, gc, this.getHoverWidth(display));
                    String line = reader.readLine();
                    while (true) {
                        if (line == null) {
                            string = buf.toString();
                            Object var9_11 = null;
                            break;
                        }
                        if (buf.length() != 0) {
                            buf.append(lineDelim);
                        }
                        buf.append(line);
                        line = reader.readLine();
                    }
                }
                catch (IOException e) {
                    CPlugin.log(e);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                gc.dispose();
                throw throwable;
            }
            gc.dispose();
            return string;
        }
        Object var9_13 = null;
        gc.dispose();
        return null;
    }

    private int getHoverWidth(Display display) {
        Rectangle displayBounds = display.getBounds();
        int hoverWidth = displayBounds.width - (display.getCursorLocation().x - displayBounds.x);
        if ((hoverWidth -= 12) < 200) {
            hoverWidth = 200;
        }
        return hoverWidth;
    }
}

