/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.FileStorage;
import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditorUtility {
    private EditorUtility() {
    }

    public static IEditorPart openInEditor(IFile file) throws PartInitException {
        IWorkbenchPage p;
        IWorkbenchWindow window = CPlugin.getActiveWorkbenchWindow();
        if (window != null && (p = window.getActivePage()) != null) {
            return p.openEditor(file);
        }
        return null;
    }

    public static IEditorPart openInEditor(ICElement element) throws PartInitException {
        IStorage store;
        IResource res = null;
        try {
            res = element.getUnderlyingResource();
        }
        catch (CModelException cModelException) {}
        if (element instanceof IBinary && (store = EditorUtility.getStorage((IBinary)element)) != null) {
            return EditorUtility.openInEditor(store, element.getElementName());
        }
        if (res != null && res instanceof IFile) {
            IEditorPart editor = EditorUtility.openInEditor((IFile)res);
            if (editor instanceof CEditor) {
                CEditor e = (CEditor)editor;
                StructuredSelection selection = new StructuredSelection((Object)element);
                e.selectionChanged(new SelectionChangedEvent((ISelectionProvider)e.getOutlinePage(), (ISelection)selection));
            }
            return editor;
        }
        return null;
    }

    public static IEditorPart openInEditor(IPath path) throws PartInitException {
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (f == null) {
            FileStorage s = new FileStorage(path);
            return EditorUtility.openInEditor((IStorage)s, path.lastSegment());
        }
        return EditorUtility.openInEditor(f);
    }

    public static IEditorPart openInEditor(IStorage store, String name) throws PartInitException {
        IWorkbenchPage p;
        ExternalEditorInput ei = new ExternalEditorInput(store);
        IWorkbenchWindow window = CPlugin.getActiveWorkbenchWindow();
        if (window != null && (p = window.getActivePage()) != null) {
            return p.openEditor((IEditorInput)ei, EditorUtility.getEditorID(name));
        }
        return null;
    }

    public static String getEditorID(String name) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        if (registry != null) {
            IEditorDescriptor descriptor = registry.getDefaultEditor(name);
            if (descriptor != null) {
                return descriptor.getId();
            }
            return registry.getDefaultEditor().getId();
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, ICElement element) {
        if (element != null) {
            boolean cfr_ignored_0 = part instanceof CEditor;
        }
    }

    public static IStorage getStorage(IBinary bin) {
        FileStorage store;
        block10: {
            store = null;
            Process objdump = null;
            IFile file = bin.getFile();
            if (file == null) {
                return store;
            }
            IPath path = file.getLocation();
            try {
                try {
                    String[] args = new String[]{"objdump", "-CxS", path.toOSString()};
                    objdump = ProcessFactory.getFactory().exec(args);
                    StringBuffer buffer = new StringBuffer();
                    BufferedReader stdout = new BufferedReader(new InputStreamReader(objdump.getInputStream()));
                    char[] buf = new char[128];
                    while (stdout.read(buf, 0, buf.length) != -1) {
                        buffer.append(buf);
                    }
                    store = new FileStorage((InputStream)new ByteArrayInputStream(buffer.toString().getBytes()), path);
                }
                catch (SecurityException securityException) {
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (objdump != null) {
                    objdump.destroy();
                }
                throw throwable;
            }
            Object var9_11 = null;
            if (objdump == null) break block10;
            objdump.destroy();
        }
        return store;
    }
}

