/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.Set;
import org.eclipse.cdt.internal.ui.util.IProblemChangedListener;
import org.eclipse.cdt.internal.ui.util.ProblemItemMapper;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class ProblemTreeViewer
extends TreeViewer
implements IProblemChangedListener {
    private ProblemItemMapper fProblemItemMapper;

    public ProblemTreeViewer(Composite parent) {
        super(parent);
        this.initMapper();
    }

    public ProblemTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initMapper();
    }

    public ProblemTreeViewer(Tree tree) {
        super(tree);
        this.initMapper();
    }

    private void initMapper() {
        this.fProblemItemMapper = new ProblemItemMapper();
    }

    public void problemsChanged(final Set changed) {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ProblemTreeViewer.this.fProblemItemMapper.problemsChanged(changed, (ILabelProvider)ProblemTreeViewer.this.getLabelProvider());
                }
            });
        }
    }

    protected void mapElement(Object element, Widget item) {
        super.mapElement(element, item);
        if (item instanceof Item) {
            this.fProblemItemMapper.addToMap(element, (Item)item);
        }
    }

    protected void unmapElement(Object element, Widget item) {
        if (item instanceof Item) {
            this.fProblemItemMapper.removeFromMap(element, (Item)item);
        }
        super.unmapElement(element);
    }

    protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
        Object source = event.getElement();
        if (source == null) {
            super.handleLabelProviderChanged(event);
            return;
        }
        super.handleLabelProviderChanged(event);
    }

    protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
        super.handleInvalidSelection(invalidSelection, newSelection);
    }
}

