/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;

public abstract class AbstractCLaunchDelegate
implements ILaunchConfigurationDelegate {
    public abstract void launch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;

    protected String[] getEnvironmentArray(ILaunchConfiguration config) {
        return null;
    }

    protected Properties getEnvironmentProperty(ILaunchConfiguration config) {
        Properties prop = new Properties();
        Map env = null;
        try {
            env = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ENVIROMENT_MAP, null);
        }
        catch (CoreException coreException) {}
        if (env == null) {
            return prop;
        }
        Iterator entries = env.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            prop.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return prop;
    }

    protected File getWorkingDir(ILaunchConfiguration config) throws CoreException {
        String path = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
        if (path == null) {
            return null;
        }
        File dir = new File(path);
        if (!dir.isDirectory()) {
            this.abort("Specified working directory does not exist or is not a directory", null, 101);
        }
        return dir;
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchUIPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public ICProject getCProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = this.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(project);
            if (cProject != null && cProject.exists()) {
                return cProject;
            }
        }
        return null;
    }

    public String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
    }

    public String getProgramName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_NAME, null);
    }

    public String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        return config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
    }

    public String[] getProgramArgumentsArray(ILaunchConfiguration config) throws CoreException {
        return AbstractCLaunchDelegate.parseArguments(this.getProgramArguments(config));
    }

    private static String[] parseArguments(String args) {
        if (args == null) {
            return new String[0];
        }
        ArgumentParser parser = new ArgumentParser(args);
        String[] res = parser.parseArguments();
        return res;
    }

    private static class ArgumentParser {
        private String fArgs;
        private int fIndex = 0;
        private int ch = -1;

        public ArgumentParser(String args) {
            this.fArgs = args;
        }

        /*
         * Unable to fully structure code
         */
        public String[] parseArguments() {
            v = new ArrayList<String>();
            this.ch = this.getNext();
            ** GOTO lbl13
            {
                this.ch = this.getNext();
                do {
                    if (Character.isWhitespace((char)this.ch)) continue block0;
                    if (this.ch == 34) {
                        v.add(this.parseString());
                        continue;
                    }
                    v.add(this.parseToken());
lbl13:
                    // 3 sources

                } while (this.ch > 0);
            }
            result = new String[v.size()];
            v.toArray(result);
            return result;
        }

        private int getNext() {
            if (this.fIndex < this.fArgs.length()) {
                return this.fArgs.charAt(this.fIndex++);
            }
            return -1;
        }

        private String parseString() {
            StringBuffer buf = new StringBuffer();
            this.ch = this.getNext();
            while (this.ch > 0 && this.ch != 34) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch != 34) {
                        buf.append('\\');
                    }
                }
                if (this.ch <= 0) continue;
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            this.ch = this.getNext();
            return buf.toString();
        }

        private String parseToken() {
            StringBuffer buf = new StringBuffer();
            while (this.ch > 0 && !Character.isWhitespace((char)this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch > 0) {
                        if (this.ch != 34) {
                            buf.append('\\');
                        }
                        buf.append((char)this.ch);
                        this.ch = this.getNext();
                        continue;
                    }
                    if (this.ch != -1) continue;
                    buf.append('\\');
                    continue;
                }
                if (this.ch == 34) {
                    buf.append(this.parseString());
                    continue;
                }
                buf.append((char)this.ch);
                this.ch = this.getNext();
            }
            return buf.toString();
        }
    }
}

