/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;

public class LocalCLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    public String renderProcessLabel(String[] commandLine) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(format, commandLine[0], timestamp);
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Launching Local C Application", -1);
        if (monitor.isCanceled()) {
            return;
        }
        ICProject cproject = this.getCProject(config);
        IPath projectPath = ((IProject)cproject.getResource()).getFile(this.getProgramName(config)).getLocation();
        String[] arguments = this.getProgramArgumentsArray(config);
        ArrayList<String> command = new ArrayList<String>(1 + arguments.length);
        command.add(projectPath.toOSString());
        command.addAll(Arrays.asList(arguments));
        if (mode.equals("debug")) {
            ICDebugConfiguration dbgCfg = null;
            ICDebugger cdebugger = null;
            try {
                dbgCfg = CDebugCorePlugin.getDefault().getDebugConfiguration(config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_ID, ""));
                cdebugger = dbgCfg.getDebugger();
            }
            catch (CoreException e) {
                Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 102, "CDT Debubger not installed", (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler != null) {
                    Object result = handler.handleStatus((IStatus)status, (Object)this);
                    boolean cfr_ignored_0 = result instanceof String;
                }
                throw e;
            }
            IFile exe = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(projectPath);
            ICDISession dsession = null;
            try {
                dsession = cdebugger.createLaunchSession(config, exe);
            }
            catch (CDIException e) {
                Status status = new Status(0, LaunchUIPlugin.getUniqueIdentifier(), 150, "CDI Error", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            ICDIRuntimeOptions opt = dsession.getRuntimeOptions();
            opt.setArguments(config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""));
            File wd = this.getWorkingDir(config);
            if (wd != null) {
                opt.setWorkingDirectory(wd.toString());
            }
            opt.setEnvironment(this.getEnvironmentProperty(config));
            ICDITarget dtarget = dsession.getTargets()[0];
            Process process = dtarget.getProcess();
            IProcess iprocess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(command.toArray(new String[command.size()])));
            boolean stopInMain = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_STOP_AT_MAIN, false);
            CDebugModel.newDebugTarget((ILaunch)launch, (ICDITarget)dsession.getTargets()[0], (String)dbgCfg.getName(), (IProcess)iprocess, (IProject)exe.getProject(), (boolean)true, (boolean)false, (boolean)stopInMain);
        } else {
            String[] commandArray = command.toArray(new String[command.size()]);
            Process process = this.exec(commandArray, this.getEnvironmentArray(config), this.getWorkingDir(config));
            DebugPlugin.getDefault();
            DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(commandArray));
        }
        monitor.done();
    }

    protected Process exec(String[] cmdLine, String[] envp, File workingDirectory) throws CoreException {
        Process p;
        block4: {
            p = null;
            try {
                p = workingDirectory == null ? Runtime.getRuntime().exec(cmdLine, envp) : Runtime.getRuntime().exec(cmdLine, envp, workingDirectory);
            }
            catch (IOException e) {
                if (p != null) {
                    p.destroy();
                }
                this.abort("Exception starting process", e, 150);
            }
            catch (NoSuchMethodError e) {
                Object result;
                Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 100, "Eclipse runtime does not support working directory", (Throwable)e);
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (handler == null || !((result = handler.handleStatus((IStatus)status, (Object)this)) instanceof Boolean) || !((Boolean)result).booleanValue()) break block4;
                p = this.exec(cmdLine, envp, null);
            }
        }
        return p;
    }
}

