/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.CLaunchConfigurationTab;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CDebuggerTab
extends CLaunchConfigurationTab {
    ArrayList fDinfo;
    int fDindex;
    Combo fDCombo;
    Button stopInMain;
    protected ILaunchConfigurationTab fDynamicTab;
    protected Composite fDynamicTabHolder;
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected ILaunchConfiguration fLaunchConfiguration;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout(3, false);
        comp.setLayout((Layout)topLayout);
        Label dlabel = new Label(comp, 0);
        dlabel.setText("Debugger:");
        this.fDCombo = new Combo(comp, 12);
        this.fDCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDebuggerTab.this.handleDebuggerComboBoxModified();
            }
        });
        this.stopInMain = new Button(comp, 32);
        this.stopInMain.setText("Stop at main() on startup.");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 128;
        this.stopInMain.setLayoutData((Object)gd);
        Group debuggerGroup = new Group(comp, 16);
        debuggerGroup.setText("Debugger Options");
        this.setDynamicTabHolder((Composite)debuggerGroup);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void setDynamicTabHolder(Composite tabHolder) {
        this.fDynamicTabHolder = tabHolder;
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTab(ILaunchConfigurationTab tab) {
        this.fDynamicTab = tab;
    }

    protected ILaunchConfigurationTab getDynamicTab() {
        return this.fDynamicTab;
    }

    protected void handleDebuggerComboBoxModified() {
        this.loadDynamicDebugArea();
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (wc == null && this.getLaunchConfiguration().isWorkingCopy()) {
                wc = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (wc != null) {
                wc.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_SPECIFIC_ATTRS_MAP, null);
            }
        } else {
            if (wc == null) {
                try {
                    wc = this.getLaunchConfiguration().isWorkingCopy() ? ((ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration()).getOriginal().getWorkingCopy() : this.getLaunchConfiguration().getWorkingCopy();
                }
                catch (CoreException coreException) {
                    return;
                }
            }
            this.getDynamicTab().setDefaults(wc);
            this.getDynamicTab().initializeFrom((ILaunchConfiguration)wc);
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration config) {
        String platform;
        try {
            platform = this.getPlatform(config);
        }
        catch (CoreException coreException) {
            return;
        }
        if (this.fDinfo != null) {
            this.fDinfo.clear();
        }
        this.fDCombo.removeAll();
        ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getDebugConfigurations();
        this.fDinfo = new ArrayList(debugConfigs.length);
        int i = 0;
        while (i < debugConfigs.length) {
            String[] supported = debugConfigs[i].getPlatforms();
            int j = 0;
            while (j < supported.length) {
                if (supported[j].equals("*") || supported[j].equalsIgnoreCase(platform)) {
                    this.fDinfo.add(debugConfigs[i]);
                    this.fDCombo.add(debugConfigs[i].getName());
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.fDCombo.getParent().layout();
    }

    protected void setSelection(String id) {
        int i = 0;
        while (i < this.fDinfo.size()) {
            ICDebugConfiguration debugConfig = (ICDebugConfiguration)this.fDinfo.get(i);
            if (debugConfig != null && debugConfig.getID().equals(id)) {
                this.fDCombo.select(i);
                return;
            }
            ++i;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        ILaunchConfigurationTab dynamicTab;
        ICDebugConfiguration dbgCfg;
        this.setLaunchConfigurationWorkingCopy(config);
        this.loadDebuggerComboBox((ILaunchConfiguration)config);
        if (this.fDinfo.size() > 0 && (dbgCfg = (ICDebugConfiguration)this.fDinfo.get(0)) != null) {
            this.setSelection(dbgCfg.getID());
            config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_ID, dbgCfg.getID());
        }
        if ((dynamicTab = this.getDynamicTab()) != null) {
            dynamicTab.setDefaults(config);
        }
        config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_STOP_AT_MAIN, false);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setLaunchConfiguration(config);
        this.loadDebuggerComboBox(config);
        try {
            String id = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_ID, "");
            this.setSelection(id);
            ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
            if (dynamicTab != null) {
                dynamicTab.initializeFrom(config);
            }
            if (config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_STOP_AT_MAIN, false)) {
                this.stopInMain.setSelection(true);
            }
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.isValid((ILaunchConfiguration)config)) {
            ICDebugConfiguration dbgCfg = (ICDebugConfiguration)this.fDinfo.get(this.fDCombo.getSelectionIndex());
            config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_ID, dbgCfg.getID());
            ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
            if (dynamicTab == null) {
                config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_SPECIFIC_ATTRS_MAP, null);
            } else {
                dynamicTab.performApply(config);
            }
            config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_STOP_AT_MAIN, this.stopInMain.getSelection());
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fDCombo.getSelectionIndex() == -1) {
            this.setErrorMessage("No debugger avalible");
            return false;
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    protected ILaunchConfigurationTab getTabForCurrentDebugger() {
        int selectedIndex = this.fDCombo.getSelectionIndex();
        if (selectedIndex >= 0 && !this.fDinfo.isEmpty()) {
            ICDebugConfiguration dbgCfg = (ICDebugConfiguration)this.fDinfo.get(selectedIndex);
            return CDebugUIPlugin.getDefault().getDebuggerPage(dbgCfg.getID());
        }
        return null;
    }

    protected void loadDynamicDebugArea() {
        Control[] children = this.getDynamicTabHolder().getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.setDynamicTab(this.getTabForCurrentDebugger());
        if (this.getDynamicTab() == null) {
            return;
        }
        this.getDynamicTab().setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        this.getDynamicTab().createControl(this.getDynamicTabHolder());
        this.getDynamicTab().getControl().setVisible(true);
        this.getDynamicTabHolder().layout(true);
    }

    public String getErrorMessage() {
        ILaunchConfigurationTab tab = this.getDynamicTab();
        if (super.getErrorMessage() != null || tab == null) {
            return super.getErrorMessage();
        }
        return tab.getErrorMessage();
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    public String getName() {
        return "Debugger";
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_DEBUGGER_TAB);
    }
}

