/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.cdt.debug.core.IDisassemblyStorage;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;

public class DisassemblyStorage
implements IDisassemblyStorage {
    protected ICDIInstruction[] fInstructions;
    protected IDebugTarget fDebugTarget;
    protected ByteArrayInputStream fInputStream = null;
    protected long fStartAddress = 0L;
    protected long fEndAddress = 0L;
    static /* synthetic */ Class class$org$eclipse$core$resources$IStorage;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$IDisassemblyStorage;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$DisassemblyStorage;

    public DisassemblyStorage(IDebugTarget target, ICDIInstruction[] instructions) {
        this.setDebugTarget(target);
        this.setInstructions(instructions);
        this.initializeAddresses();
        this.createContent();
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public boolean containsAddress(long address) {
        return address >= this.fStartAddress && address <= this.fEndAddress;
    }

    public int getLineNumber(long address) {
        return 0;
    }

    public InputStream getContents() throws CoreException {
        if (this.fInputStream != null) {
            this.fInputStream.reset();
        }
        return this.fInputStream;
    }

    public IPath getFullPath() {
        return null;
    }

    public String getName() {
        try {
            if (this.getDebugTarget() != null) {
                return this.getDebugTarget().getName();
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return "disassembly";
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$core$resources$IStorage == null ? (class$org$eclipse$core$resources$IStorage = DisassemblyStorage.class$("org.eclipse.core.resources.IStorage")) : class$org$eclipse$core$resources$IStorage)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$core$IDisassemblyStorage == null ? (class$org$eclipse$cdt$debug$core$IDisassemblyStorage = DisassemblyStorage.class$("org.eclipse.cdt.debug.core.IDisassemblyStorage")) : class$org$eclipse$cdt$debug$core$IDisassemblyStorage)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$DisassemblyStorage == null ? (class$org$eclipse$cdt$debug$internal$core$DisassemblyStorage = DisassemblyStorage.class$("org.eclipse.cdt.debug.internal.core.DisassemblyStorage")) : class$org$eclipse$cdt$debug$internal$core$DisassemblyStorage)) {
            return this;
        }
        return null;
    }

    protected void setDebugTarget(IDebugTarget target) {
        this.fDebugTarget = target;
    }

    protected void setInstructions(ICDIInstruction[] intructions) {
        this.fInstructions = intructions;
    }

    private void createContent() {
        StringBuffer lines = new StringBuffer();
        int i = 0;
        while (i < this.fInstructions.length) {
            lines.append(this.fInstructions[i].toString());
            ++i;
        }
        this.fInputStream = new ByteArrayInputStream(lines.toString().getBytes());
    }

    private void initializeAddresses() {
        if (this.fInstructions.length > 0) {
            this.fStartAddress = this.fInstructions[0].getAdress();
            this.fEndAddress = this.fInstructions[this.fInstructions.length - 1].getAdress();
        }
    }

    private String getInstructionString(ICDIInstruction instruction) {
        StringBuffer sb = new StringBuffer();
        if (instruction != null) {
            // empty if block
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

