/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.IStackFrameInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CProjectSourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;

public class CSourceLocator
implements ICSourceLocator,
IPersistableSourceLocator {
    private ICSourceLocation[] fSourceLocations;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$IStackFrameInfo;

    public CSourceLocator() {
        this.setSourceLocations(new ICSourceLocation[0]);
    }

    public CSourceLocator(IProject project) {
        this.fSourceLocations = CSourceLocator.getDefaultSourceLocations(project);
    }

    public CSourceLocator(ICSourceLocation[] locations) {
        this.fSourceLocations = locations;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        if (stackFrame != null && stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$IStackFrameInfo = CSourceLocator.class$("org.eclipse.cdt.debug.core.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$IStackFrameInfo) != null) {
            return this.getInput((IStackFrameInfo)stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$IStackFrameInfo = CSourceLocator.class$("org.eclipse.cdt.debug.core.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$IStackFrameInfo));
        }
        return null;
    }

    public int getLineNumber(IStackFrameInfo frameInfo) {
        return frameInfo != null ? frameInfo.getFrameLineNumber() : 0;
    }

    protected Object getInput(IStackFrameInfo info) {
        String fileName;
        Object result = null;
        if (info != null && (fileName = info.getFile()) != null && fileName.length() > 0) {
            ICSourceLocation[] locations = this.getSourceLocations();
            int i = 0;
            while (i < locations.length) {
                try {
                    result = locations[i].findSourceElement(fileName);
                }
                catch (CoreException e) {
                    // empty catch block
                }
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    public boolean contains(IResource resource) {
        ICSourceLocation[] locations = this.getSourceLocations();
        int i = 0;
        while (i < locations.length) {
            if (resource instanceof IProject && locations[i] instanceof CProjectSourceLocation && ((CProjectSourceLocation)locations[i]).equals(resource)) {
                return true;
            }
            if (resource instanceof IFile) {
                try {
                    if (locations[i].findSourceElement(resource.getLocation().toOSString()) != null) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return false;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.fSourceLocations;
    }

    public void setSourceLocations(ICSourceLocation[] locations) {
        this.fSourceLocations = locations;
    }

    public static ICSourceLocation[] getDefaultSourceLocations(IProject project) {
        ArrayList<CProjectSourceLocation> list = new ArrayList<CProjectSourceLocation>();
        if (project != null) {
            try {
                IProject[] projects = project.getReferencedProjects();
                list.add(new CProjectSourceLocation(project));
                int i = 0;
                while (i < projects.length) {
                    list.add(new CProjectSourceLocation(projects[i]));
                    ++i;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    public String getMemento() throws CoreException {
        return null;
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
    }

    public void initializeFromMemento(String memento) throws CoreException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

