/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.IStackFrameInfo;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.internal.core.DisassemblyStorage;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;

public class DisassemblyManager {
    private static final int DISASSEMBLY_BLOCK_SIZE = 100;
    private CDebugTarget fDebugTarget;
    private DisassemblyStorage fStorage = null;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$IStackFrameInfo;

    public DisassemblyManager(CDebugTarget target) {
        this.setDebugTarget(target);
    }

    public int getLineNumber(IStackFrameInfo frameInfo) {
        DisassemblyStorage storage = this.getSourceElement(frameInfo);
        if (storage != null) {
            return storage.getLineNumber(frameInfo.getAddress());
        }
        return 0;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        if (stackFrame != null) {
            return this.getSourceElement((IStackFrameInfo)stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$IStackFrameInfo = DisassemblyManager.class$("org.eclipse.cdt.debug.core.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$IStackFrameInfo));
        }
        return null;
    }

    private void setDebugTarget(CDebugTarget target) {
        this.fDebugTarget = target;
    }

    public CDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    private void setDisassemblyStorage(DisassemblyStorage ds) {
        this.fStorage = ds;
    }

    protected DisassemblyStorage getDisassemblyStorage() {
        return this.fStorage;
    }

    private DisassemblyStorage getSourceElement(IStackFrameInfo frameInfo) {
        DisassemblyStorage storage = null;
        if (frameInfo != null) {
            long address = frameInfo.getAddress();
            storage = this.getDisassemblyStorage() != null && this.getDisassemblyStorage().containsAddress(address) ? this.getDisassemblyStorage() : this.loadDisassemblyStorage(frameInfo);
        }
        return storage;
    }

    private DisassemblyStorage loadDisassemblyStorage(IStackFrameInfo frameInfo) {
        ICDISourceManager sm;
        this.setDisassemblyStorage(null);
        if (frameInfo != null && this.getDebugTarget() != null && this.getDebugTarget().isSuspended() && (sm = this.getDebugTarget().getCDISession().getSourceManager()) != null) {
            long address;
            String fileName = frameInfo.getFile();
            int lineNumber = frameInfo.getFrameLineNumber();
            ICDIInstruction[] instructions = new ICDIInstruction[]{};
            try {
                instructions = sm.getInstructions(fileName, lineNumber);
            }
            catch (CDIException e) {
                // empty catch block
            }
            if (instructions.length == 0 && (address = frameInfo.getAddress()) >= 0L) {
                try {
                    instructions = sm.getInstructions("0x" + Long.toHexString(address), "0x" + Long.toHexString(address + 100L));
                }
                catch (CDIException e) {
                    CDebugCorePlugin.log(e);
                }
            }
            if (instructions.length > 0) {
                this.setDisassemblyStorage(new DisassemblyStorage(this.getDebugTarget(), instructions));
            }
        }
        return this.getDisassemblyStorage();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

