/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import org.eclipse.cdt.internal.corext.textmanipulation.ISourceRange;
import org.eclipse.cdt.internal.corext.textmanipulation.TextManipulationMessages;
import org.eclipse.jface.util.Assert;

public final class TextRange {
    int fOffset;
    int fLength;
    public static final TextRange UNDEFINED = new TextRange((TextRange)null);

    public TextRange(int offset) {
        this(offset, 0);
    }

    public TextRange(int offset, int length) {
        this.fOffset = offset;
        Assert.isTrue((this.fOffset >= 0 ? 1 : 0) != 0);
        this.fLength = length;
        Assert.isTrue((this.fLength >= 0 ? 1 : 0) != 0);
    }

    private TextRange(TextRange dummy) {
        this.fOffset = -1;
        this.fLength = -1;
    }

    public static TextRange createFromStartAndLength(int start, int length) {
        return new TextRange(start, length);
    }

    public static TextRange createFromStartAndInclusiveEnd(int start, int end) {
        return new TextRange(start, end - start + 1);
    }

    public static TextRange createFromStartAndExclusiveEnd(int start, int end) {
        return new TextRange(start, end - start);
    }

    public TextRange(ISourceRange range) {
        this(range.getOffset(), range.getLength());
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getInclusiveEnd() {
        return this.fOffset + this.fLength - 1;
    }

    public int getExclusiveEnd() {
        return this.fOffset + this.fLength;
    }

    public TextRange copy() {
        if (this.isUndefined()) {
            return this;
        }
        return new TextRange(this.fOffset, this.fLength);
    }

    public boolean isUndefined() {
        return UNDEFINED == this;
    }

    public boolean isValid() {
        return this.fOffset >= 0 && this.fLength >= 0;
    }

    boolean isInsertionPoint() {
        return this.fLength == 0;
    }

    boolean equals(TextRange range) {
        return this.fOffset == range.fOffset && this.fLength == range.fLength;
    }

    boolean isEqualInsertionPoint(TextRange range) {
        return this.fLength == 0 && range.fLength == 0 && this.fOffset == range.fOffset;
    }

    boolean liesBehind(TextRange range) {
        return this.fOffset >= range.fOffset + range.fLength;
    }

    boolean isInsertionPointAt(int o) {
        return this.fOffset == o && this.fLength == 0;
    }

    boolean covers(TextRange other) {
        if (this.fLength == 0) {
            return false;
        }
        if (other.fLength == 0) {
            int otherOffset = other.fOffset;
            return this.fOffset < otherOffset && otherOffset < this.fOffset + this.fLength;
        }
        int otherOffset = other.fOffset;
        return this.fOffset <= otherOffset && otherOffset + other.fLength <= this.fOffset + this.fLength;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(TextManipulationMessages.getString("TextRange.offset"));
        buffer.append(this.fOffset);
        buffer.append(TextManipulationMessages.getString("TextRange.length"));
        buffer.append(this.fLength);
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRange)) {
            return false;
        }
        TextRange other = (TextRange)obj;
        return this.fOffset == other.getOffset() && this.fLength == other.getLength();
    }

    public int hashCode() {
        return this.fOffset ^ this.fLength;
    }
}

