/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICFile;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BaseCElementContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers = false;
    protected boolean fProvideWorkingCopy = false;

    public BaseCElementContentProvider() {
    }

    public BaseCElementContentProvider(boolean provideMembers, boolean provideWorkingCopy) {
        this.fProvideMembers = provideMembers;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean b) {
        this.fProvideMembers = b;
    }

    public void setProvideWorkingCopy(boolean b) {
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (element instanceof ICElement) {
            ICElement celement = (ICElement)element;
            if (celement.getElementType() == 13) {
                if (this.fProvideMembers) {
                    return ((IParent)element).getChildren();
                }
            } else if (celement instanceof IParent) {
                if (celement instanceof ICProject) {
                    ICElement[] children = ((IParent)celement).getChildren();
                    ArrayList<ICElement> list = new ArrayList<ICElement>(children.length);
                    int i = 0;
                    while (i < children.length) {
                        if (!(children[i] instanceof IArchiveContainer) && !(children[i] instanceof IBinaryContainer) || ((IParent)children[i]).getChildren().length != 0) {
                            list.add(children[i]);
                        }
                        ++i;
                    }
                    return list.toArray();
                }
                return ((IParent)celement).getChildren();
            }
        }
        return this.getResources(element);
    }

    public boolean hasChildren(Object element) {
        ICProject cp;
        if (this.fProvideMembers) {
            ICFile cfile;
            if (element instanceof ICFile && ((cfile = (ICFile)element).isBinary() || cfile.isTranslationUnit() || cfile.isArchive())) {
                return true;
            }
        } else if (element instanceof ICFile || element instanceof IFile) {
            return false;
        }
        if (element instanceof ICProject && !(cp = (ICProject)element).getProject().isOpen()) {
            return false;
        }
        if (element instanceof IParent) {
            return ((IParent)element).hasChildren();
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object getParent(Object element) {
        if (element instanceof ICElement) {
            return ((ICElement)element).getParent();
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    private Object[] getResources(Object resource) {
        try {
            if (resource instanceof IContainer) {
                IResource[] members = ((IContainer)resource).members();
                ArrayList<IResource> nonCResources = new ArrayList<IResource>();
                int i = 0;
                while (i < members.length) {
                    IResource o = members[i];
                    nonCResources.add(o);
                    ++i;
                }
                return nonCResources.toArray();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return NO_CHILDREN;
    }

    protected boolean exists(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IResource) {
            return ((IResource)element).exists();
        }
        if (element instanceof ICElement) {
            return ((ICElement)element).exists();
        }
        return true;
    }
}

