/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.BuildConsoleAction;
import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.ClearConsoleAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.TextEditorAction;

public class BuildConsoleView
extends ViewPart {
    private TextViewer fTextViewer;
    private ClearConsoleAction fClearOutputAction;
    private TextEditorAction fCopyAction;
    private TextEditorAction fSelectAllAction;
    private Font fFont = null;
    private IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (BuildConsoleView.this.fTextViewer != null && event.getProperty().equals("consoleFont")) {
                BuildConsoleView.this.initializeWidgetFont(BuildConsoleView.this.fTextViewer.getTextWidget());
            }
        }
    };

    public BuildConsoleView() {
        IPreferenceStore store = CPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    private void initializeActions() {
        ResourceBundle bundle = CPlugin.getResourceBundle();
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fClearOutputAction = new ClearConsoleAction(this);
        this.fCopyAction = new BuildConsoleAction(bundle, "Editor.Copy.", this.fTextViewer, 4);
        this.fSelectAllAction = new BuildConsoleAction(bundle, "Editor.SelectAll.", this.fTextViewer, 7);
        actionBars.setGlobalActionHandler("copy", (IAction)this.fCopyAction);
        actionBars.setGlobalActionHandler("selectAll", (IAction)this.fSelectAllAction);
    }

    public void createPartControl(Composite parent) {
        this.fTextViewer = new TextViewer(parent, 834);
        this.fTextViewer.setDocument(CPlugin.getDefault().getConsoleDocument());
        this.fTextViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                BuildConsoleView.this.revealEndOfDocument();
            }
        });
        this.fTextViewer.setEditable(false);
        this.initializeWidgetFont(this.fTextViewer.getTextWidget());
        this.initializeActions();
        this.initializeContextMenu((Control)parent);
        this.initializeToolBar();
        WorkbenchHelp.setHelp((Control)this.fTextViewer.getControl(), (String)"org.eclipse.cdt.ui.clear_console_view_context");
    }

    private void initializeWidgetFont(StyledText styledText) {
        IPreferenceStore store = CPlugin.getDefault().getPreferenceStore();
        String prefKey = "consoleFont";
        FontData data = null;
        data = store.contains(prefKey) && !store.isDefault(prefKey) ? PreferenceConverter.getFontData((IPreferenceStore)store, (String)prefKey) : PreferenceConverter.getDefaultFontData((IPreferenceStore)store, (String)prefKey);
        if (data != null) {
            Font font = new Font((Device)styledText.getDisplay(), data);
            styledText.setFont(font);
            if (this.fFont != null) {
                this.fFont.dispose();
            }
            this.fFont = font;
        } else {
            styledText.setFont(JFaceResources.getTextFont());
        }
    }

    public void setFocus() {
    }

    protected void initializeContextMenu(Control parent) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BuildConsoleView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(parent);
        parent.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager menu) {
        this.fCopyAction.update();
        menu.add((IAction)this.fCopyAction);
        menu.add((IAction)this.fSelectAllAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fClearOutputAction);
    }

    private void initializeToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getToolBarManager().add((IAction)this.fClearOutputAction);
        actionBars.updateActionBars();
    }

    void clear() {
        CPlugin.getDefault().getConsole().clear();
    }

    protected void revealEndOfDocument() {
        IDocument doc = this.fTextViewer.getDocument();
        int docLength = doc.getLength();
        if (docLength > 0) {
            this.fTextViewer.revealRange(docLength - 1, 1);
            StyledText widget = this.fTextViewer.getTextWidget();
            widget.setCaretOffset(docLength);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fPropertyChangeListener != null) {
            IPreferenceStore store = CPlugin.getDefault().getPreferenceStore();
            store.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
    }
}

