/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.cview.CPatternFilter;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

class FiltersContentProvider
implements IStructuredContentProvider {
    private static List fgDefinedFilters;
    private static List fgDefaultFilters;
    private CPatternFilter filter;

    public void dispose() {
    }

    public static List getDefaultFilters() {
        if (fgDefaultFilters == null) {
            FiltersContentProvider.readFilters();
        }
        return fgDefaultFilters;
    }

    public static List getDefinedFilters() {
        if (fgDefinedFilters == null) {
            FiltersContentProvider.readFilters();
        }
        return fgDefinedFilters;
    }

    public Object[] getElements(Object inputElement) {
        return FiltersContentProvider.getDefinedFilters().toArray();
    }

    public String[] getInitialSelections() {
        return this.filter.getPatterns();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public FiltersContentProvider(CPatternFilter filter) {
        this.filter = filter;
    }

    private static void readFilters() {
        IExtensionPoint extension;
        fgDefinedFilters = new ArrayList();
        fgDefaultFilters = new ArrayList();
        CPlugin plugin = CPlugin.getDefault();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint(CPatternFilter.FILTERS_TAG)) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String selected;
                    String pattern = configElements[j].getAttribute("pattern");
                    if (pattern != null) {
                        fgDefinedFilters.add(pattern);
                    }
                    if ((selected = configElements[j].getAttribute("selected")) != null && selected.equalsIgnoreCase("true")) {
                        fgDefaultFilters.add(pattern);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

