/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.internal.ui.editor.IPainter;
import org.eclipse.cdt.internal.ui.editor.IPositionManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;

public class LinePainter
implements IPainter,
LineBackgroundListener {
    private StyledText fTextWidget;
    private Color fHighlightColor;
    private int[] fLine = new int[]{-1, -1};
    private boolean fIsActive = false;

    public LinePainter(ISourceViewer sourceViewer) {
        this.fTextWidget = sourceViewer.getTextWidget();
    }

    public void setHighlightColor(Color highlightColor) {
        this.fHighlightColor = highlightColor;
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        if (this.fTextWidget != null) {
            int caret = this.fTextWidget.getCaretOffset();
            int length = event.lineText.length();
            if (event.lineOffset <= caret && caret <= event.lineOffset + length && this.fIsActive) {
                StyledTextContent content = this.fTextWidget.getContent();
                Point p = this.fTextWidget.getSelectionRange();
                event.lineBackground = content.getLineAtOffset(caret) == content.getLineAtOffset(p.x) ? this.fHighlightColor : this.fTextWidget.getBackground();
            } else {
                event.lineBackground = this.fTextWidget.getBackground();
            }
        }
    }

    private void updateHighlightLine() {
        int length;
        StyledTextContent content = this.fTextWidget.getContent();
        int offset = this.fTextWidget.getCaretOffset();
        if (offset > (length = content.getCharCount())) {
            offset = length;
        }
        int lineNumber = content.getLineAtOffset(offset);
        this.fLine[0] = content.getOffsetAtLine(lineNumber);
        try {
            this.fLine[1] = content.getOffsetAtLine(lineNumber + 1);
        }
        catch (IllegalArgumentException x) {
            this.fLine[1] = -1;
        }
    }

    private void clearHighlightLine() {
        if (this.fLine[0] <= this.fTextWidget.getCharCount()) {
            this.drawHighlightLine();
        }
    }

    private void drawHighlightLine() {
        if (this.fLine[1] >= this.fTextWidget.getCharCount()) {
            this.fLine[1] = -1;
        }
        if (this.fLine[1] == -1) {
            Point upperLeft = this.fTextWidget.getLocationAtOffset(this.fLine[0]);
            int width = this.fTextWidget.getClientArea().width;
            int height = this.fTextWidget.getLineHeight();
            this.fTextWidget.redraw(upperLeft.x, upperLeft.y, width, height, false);
        } else {
            this.fTextWidget.redrawRange(this.fLine[0], this.fLine[1] - this.fLine[0], true);
        }
    }

    public void deactivate(boolean redraw) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removeLineBackgroundListener((LineBackgroundListener)this);
            if (redraw) {
                this.drawHighlightLine();
            }
        }
    }

    public void dispose() {
        this.fTextWidget = null;
    }

    public void paint(int reason) {
        if (!this.fIsActive) {
            this.fIsActive = true;
            this.fTextWidget.addLineBackgroundListener((LineBackgroundListener)this);
        } else if (this.fLine[0] != -1) {
            this.clearHighlightLine();
        }
        this.updateHighlightLine();
        this.drawHighlightLine();
    }

    public void setPositionManager(IPositionManager manager) {
    }
}

