/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.preferences.ICDebugPreferenceConstants;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class MemoryViewPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public MemoryViewPreferencePage() {
        super(1);
        this.setDescription("Debug Memory View Settings.");
        this.setPreferenceStore(CDebugUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)parent, (String)ICDebugHelpContextIds.MEMORY_PREFERENCE_PAGE);
    }

    protected void createFieldEditors() {
        ColorFieldEditor foreground = new ColorFieldEditor("Memory.Foreground.RGB", "Text Color:", this.getFieldEditorParent());
        ColorFieldEditor background = new ColorFieldEditor("Memory.background.RGB", "Background Color:", this.getFieldEditorParent());
        ColorFieldEditor address = new ColorFieldEditor("Memory.Address.RGB", "Address Color:", this.getFieldEditorParent());
        ColorFieldEditor changed = new ColorFieldEditor("Memory.Changed.RGB", "Changed Value Color:", this.getFieldEditorParent());
        ColorFieldEditor dirty = new ColorFieldEditor("Memory.Dirty.RGB", "Modified Value Color:", this.getFieldEditorParent());
        FontFieldEditor font = new FontFieldEditor("Memory.font", "Font:", this.getFieldEditorParent());
        this.addField((FieldEditor)foreground);
        this.addField((FieldEditor)background);
        this.addField((FieldEditor)address);
        this.addField((FieldEditor)changed);
        this.addField((FieldEditor)dirty);
        this.addField((FieldEditor)font);
        StringFieldEditor paddingChar = new StringFieldEditor("Memory.PaddingChar", "Padding Character:", 1, this.getFieldEditorParent());
        paddingChar.setTextLimit(1);
        this.addField((FieldEditor)paddingChar);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault("Memory.PaddingChar", ".");
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"Memory.font", (FontData)ICDebugPreferenceConstants.DEFAULT_MEMORY_FONT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"Memory.Foreground.RGB", (RGB)ICDebugPreferenceConstants.DEFAULT_MEMORY_FOREGROUND_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"Memory.background.RGB", (RGB)ICDebugPreferenceConstants.DEFAULT_MEMORY_BACKGROUND_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"Memory.Address.RGB", (RGB)ICDebugPreferenceConstants.DEFAULT_MEMORY_ADDRESS_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"Memory.Changed.RGB", (RGB)ICDebugPreferenceConstants.DEFAULT_MEMORY_CHANGED_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"Memory.Dirty.RGB", (RGB)ICDebugPreferenceConstants.DEFAULT_MEMORY_DIRTY_RGB);
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        CDebugUIPlugin.getDefault().savePluginPreferences();
        return ok;
    }
}

