/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.debug.core.IFormattedMemoryBlock;
import org.eclipse.cdt.debug.core.IFormattedMemoryBlockRow;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.swt.graphics.Point;

public class MemoryPresentation {
    private static final char NOT_AVAILABLE_CHAR = '?';
    private static final int INTERVAL_BETWEEN_ADDRESS_AND_DATA = 2;
    private static final int INTERVAL_BETWEEN_DATA_ITEMS = 1;
    private static final int INTERVAL_BETWEEN_DATA_AND_ASCII = 1;
    private IFormattedMemoryBlock fBlock;
    private List fAddressZones = new LinkedList();
    private List fChangedZones = new LinkedList();
    private List fDirtyZones = new LinkedList();

    public IFormattedMemoryBlock getMemoryBlock() {
        return this.fBlock;
    }

    public void setMemoryBlock(IFormattedMemoryBlock block) {
        this.fBlock = block;
    }

    public String getText() {
        this.fAddressZones.clear();
        IFormattedMemoryBlockRow[] rows = this.fBlock.getRows();
        String text = new String();
        int i = 0;
        while (i < rows.length) {
            int offset = text.length();
            text = text + this.getRowText(rows[i]);
            this.fAddressZones.add(new Point(offset, offset + this.getAddressLength()));
            ++i;
        }
        return text;
    }

    public int getItemSize(int offset) {
        return -1;
    }

    public void setItem(int offset, String item) {
    }

    public String[] getText(Point[] zones) {
        return new String[0];
    }

    public boolean isAcceptable(char ch, int offset) {
        return true;
    }

    public Point[] getAddressZones() {
        return this.fAddressZones.toArray(new Point[0]);
    }

    public Point[] getChangedZones() {
        return this.fChangedZones.toArray(new Point[0]);
    }

    public Point[] getDirtyZones() {
        return this.fDirtyZones.toArray(new Point[0]);
    }

    public String getStartAddress() {
        return this.fBlock != null ? this.getAddressString(this.fBlock.getStartAddress()) : "";
    }

    private String getInterval(int length) {
        char[] chars = new char[length];
        int i = 0;
        while (i < chars.length) {
            chars[i] = 32;
            ++i;
        }
        return new String(chars);
    }

    private String getAddressString(long address) {
        return CDebugUIUtils.toHexAddressString(address);
    }

    private String getRowText(IFormattedMemoryBlockRow row) {
        String result = this.getAddressString(row.getAddress()) + this.getInterval(2);
        String[] items = row.getData();
        int i = 0;
        while (i < items.length) {
            result = result + items[i] + this.getInterval(1);
            ++i;
        }
        result = result + this.getInterval(1) + row.getASCII() + '\n';
        return result;
    }

    private String resize(String item, char ch, int size) {
        char[] chars = new char[size - item.length()];
        int i = 0;
        while (i < chars.length) {
            chars[i] = ch;
            ++i;
        }
        return String.valueOf(chars).concat(item);
    }

    private int getAddressLength() {
        return 10;
    }
}

