/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.memory;

import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewEventHandler;
import org.eclipse.cdt.debug.internal.ui.views.memory.MemoryViewer;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class MemoryView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IDebugExceptionHandler {
    private IDebugModelPresentation fModelPresentation = null;

    protected Viewer createViewer(Composite parent) {
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MemoryViewer viewer = new MemoryViewer(parent);
        viewer.setContentProvider(this.createContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)this.getModelPresentation());
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler((Viewer)viewer));
        return viewer;
    }

    protected void createActions() {
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.MEMORY_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        ((MemoryViewer)this.getViewer()).propertyChange(event);
    }

    public void handleException(DebugException e) {
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        Object current;
        Object input;
        IDebugTarget memoryBlockRetrieval = null;
        if (ssel.size() == 1 && (input = ssel.getFirstElement()) instanceof IDebugElement) {
            memoryBlockRetrieval = ((IDebugElement)input).getDebugTarget();
        }
        if ((current = this.getViewer().getInput()) == null && memoryBlockRetrieval == null) {
            return;
        }
        if (current != null && current.equals(memoryBlockRetrieval)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput((Object)memoryBlockRetrieval);
    }

    private IContentProvider createContentProvider() {
        return new MemoryViewContentProvider();
    }

    private IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = CDebugUIPlugin.getDebugModelPresentation();
        }
        return this.fModelPresentation;
    }

    protected AbstractDebugEventHandler createEventHandler(Viewer viewer) {
        return new MemoryViewEventHandler(this);
    }
}

