/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.IStackFrameInfo;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLocator;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CUISourceLocator
implements IPersistableSourceLocator {
    public static final String ID_PROMPTING_C_SOURCE_LOCATOR = CDebugUIPlugin.getUniqueIdentifier() + ".cSourceLocator";
    private IProject fProject = null;
    private CSourceLocator fSourceLocator;
    protected boolean fAllowedToAsk;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$IStackFrameInfo;

    public CUISourceLocator() {
        this.fSourceLocator = new CSourceLocator();
        this.fAllowedToAsk = true;
    }

    public CUISourceLocator(IProject project) {
        this.fProject = project;
        this.fSourceLocator = new CSourceLocator(project);
        this.fAllowedToAsk = true;
    }

    public String getMemento() throws CoreException {
        return this.fSourceLocator.getMemento();
    }

    public void initializeFromMemento(String memento) throws CoreException {
        this.fSourceLocator.initializeFromMemento(memento);
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.fSourceLocator.initializeDefaults(configuration);
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        IStackFrameInfo frameInfo;
        Object res = this.fSourceLocator.getSourceElement(stackFrame);
        if (res == null && this.fAllowedToAsk && (frameInfo = (IStackFrameInfo)stackFrame.getAdapter(class$org$eclipse$cdt$debug$core$IStackFrameInfo == null ? (class$org$eclipse$cdt$debug$core$IStackFrameInfo = CUISourceLocator.class$("org.eclipse.cdt.debug.core.IStackFrameInfo")) : class$org$eclipse$cdt$debug$core$IStackFrameInfo)) != null) {
            this.showDebugSourcePage(frameInfo.getFile(), stackFrame.getLaunch().getLaunchConfiguration());
            res = this.fSourceLocator.getSourceElement(stackFrame);
        }
        return res;
    }

    private void showDebugSourcePage(final String fileName, final ILaunchConfiguration lc) {
        Runnable prompter = new Runnable(){

            public void run() {
                SourceLookupDialog dialog = new SourceLookupDialog(CDebugUIPlugin.getActiveWorkbenchShell(), fileName, lc, CUISourceLocator.this);
                dialog.open();
                CUISourceLocator.this.fAllowedToAsk = !dialog.isNotAskAgain();
            }
        };
        CDebugUIPlugin.getStandardDisplay().syncExec(prompter);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SourceLookupDialog
    extends Dialog {
        private CUISourceLocator fLocator;
        private ILaunchConfiguration fConfiguration;
        private String fFileName;
        private boolean fNotAskAgain;
        private Button fAskAgainCheckBox;

        public SourceLookupDialog(Shell shell, String fileName, ILaunchConfiguration configuration, CUISourceLocator locator) {
            super(shell);
            this.fFileName = fileName;
            this.fNotAskAgain = false;
            this.fAskAgainCheckBox = null;
            this.fLocator = locator;
            this.fConfiguration = configuration;
        }

        public boolean isNotAskAgain() {
            return this.fNotAskAgain;
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText("Debugger Source Lookup");
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout());
            Label message = new Label(composite, 16448);
            message.setText(MessageFormat.format("The source could not be shown as the file ''{0}'' was not found.", this.fFileName));
            GridData data = new GridData();
            data.widthHint = this.convertWidthInCharsToPixels((Control)message, 70);
            message.setLayoutData((Object)data);
            this.fAskAgainCheckBox = new Button(composite, 96);
            data = new GridData();
            data.widthHint = this.convertWidthInCharsToPixels((Control)this.fAskAgainCheckBox, 70);
            this.fAskAgainCheckBox.setLayoutData((Object)data);
            this.fAskAgainCheckBox.setText("Do &not ask again");
            return composite;
        }

        protected int convertWidthInCharsToPixels(Control control, int chars) {
            GC gc = new GC((Drawable)control);
            gc.setFont(control.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
        }

        protected void okPressed() {
            try {
                ILaunchConfigurationWorkingCopy wc;
                if (this.fAskAgainCheckBox != null) {
                    this.fNotAskAgain = this.fAskAgainCheckBox.getSelection();
                }
                if (!this.fConfiguration.contentsEqual((ILaunchConfiguration)(wc = this.fConfiguration.getWorkingCopy()))) {
                    this.fConfiguration = wc.doSave();
                    this.fLocator.initializeDefaults(this.fConfiguration);
                }
            }
            catch (CoreException e) {
                CDebugUIPlugin.log(e);
            }
            super.okPressed();
        }
    }
}

