/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;

public class Location
implements ICDILocation {
    long addr;
    String file = "";
    String function = "";
    int line;

    public Location(String f, String fnct, int l) {
        this(f, fnct, l, 0L);
    }

    public Location(String f, String fnct, int l, long a) {
        if (f != null) {
            this.file = f;
        }
        if (fnct != null) {
            this.function = fnct;
        }
        this.line = l;
        this.addr = a;
    }

    public long getAddress() {
        return this.addr;
    }

    public String getFile() {
        return this.file;
    }

    public String getFunction() {
        return this.function;
    }

    public ICDIInstruction[] getInstructions() throws CDIException {
        return new ICDIInstruction[0];
    }

    public ICDIInstruction[] getInstructions(int maxCount) throws CDIException {
        return new ICDIInstruction[0];
    }

    public int getLineNumber() {
        return this.line;
    }

    public boolean equals(ICDILocation location) {
        String ofunction;
        String ofile = location.getFile();
        if (ofile == null) {
            ofile = "";
        }
        if ((ofunction = location.getFunction()) == null) {
            ofunction = "";
        }
        if (this.file.equals(ofile) && this.line == location.getLineNumber()) {
            return true;
        }
        if (this.file.equals(ofile) && this.function.equals(ofunction)) {
            return true;
        }
        return super.equals(location);
    }
}

