/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointHit;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.cdi.EndSteppingRange;
import org.eclipse.cdt.debug.mi.core.cdi.Signal;
import org.eclipse.cdt.debug.mi.core.cdi.WatchpointScope;
import org.eclipse.cdt.debug.mi.core.cdi.WatchpointTrigger;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIFunctionFinishedEvent;
import org.eclipse.cdt.debug.mi.core.event.MILocationReachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalEvent;
import org.eclipse.cdt.debug.mi.core.event.MISteppingRangeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointScopeEvent;
import org.eclipse.cdt.debug.mi.core.event.MIWatchpointTriggerEvent;

public class SuspendedEvent
implements ICDISuspendedEvent {
    MIEvent event;
    CSession session;

    public SuspendedEvent(CSession s, MIEvent e) {
        this.session = s;
        this.event = e;
    }

    public ICDISessionObject getReason() {
        if (this.event instanceof MIBreakpointEvent) {
            return new BreakpointHit(this.session, (MIBreakpointEvent)this.event);
        }
        if (this.event instanceof MIWatchpointTriggerEvent) {
            return new WatchpointTrigger(this.session, (MIWatchpointTriggerEvent)this.event);
        }
        if (this.event instanceof MIWatchpointScopeEvent) {
            return new WatchpointScope(this.session, (MIWatchpointScopeEvent)this.event);
        }
        if (this.event instanceof MISteppingRangeEvent) {
            return new EndSteppingRange(this.session);
        }
        if (this.event instanceof MISignalEvent) {
            return new Signal(this.session, (MISignalEvent)this.event);
        }
        if (this.event instanceof MILocationReachedEvent) {
            return new EndSteppingRange(this.session);
        }
        if (this.event instanceof MIFunctionFinishedEvent) {
            return new EndSteppingRange(this.session);
        }
        return this.session;
    }

    public ICDIObject getSource() {
        CTarget target = this.session.getCTarget();
        return target;
    }
}

