/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIWatchpointTriggerEvent
extends MIStoppedEvent {
    int number;
    String exp = "";
    String oldValue = "";
    String newValue = "";
    int threadId;
    MIFrame frame;
    MIExecAsyncOutput exec;
    MIResultRecord rr;

    public MIWatchpointTriggerEvent(MIExecAsyncOutput record) {
        this.exec = record;
        this.parse();
    }

    public MIWatchpointTriggerEvent(MIResultRecord record) {
        this.rr = record;
        this.parse();
    }

    public int getNumber() {
        return this.number;
    }

    public String getExpression() {
        return this.exp;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public MIFrame getFrame() {
        return this.frame;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("number=").append(this.number).append('\n');
        buffer.append("expression=" + this.exp + "\n");
        buffer.append("old=" + this.oldValue + "\n");
        buffer.append("new=" + this.newValue + "\n");
        buffer.append("thread-id=").append(this.threadId).append('\n');
        buffer.append(this.frame.toString());
        return buffer.toString();
    }

    void parse() {
        MIResult[] results = null;
        if (this.exec != null) {
            results = this.exec.getMIResults();
        } else if (this.rr != null) {
            results = this.rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                if (var.equals("wpt")) {
                    if (value instanceof MITuple) {
                        this.parseWPT((MITuple)value);
                    }
                } else if (var.equals("value")) {
                    if (value instanceof MITuple) {
                        this.parseValue((MITuple)value);
                    }
                } else if (var.equals("thread-id")) {
                    if (value instanceof MIConst) {
                        String str = ((MIConst)value).getString();
                        try {
                            this.threadId = Integer.parseInt(str.trim());
                        }
                        catch (NumberFormatException e) {}
                    }
                } else if (var.equals("frame") && value instanceof MITuple) {
                    this.frame = new MIFrame((MITuple)value);
                }
                ++i;
            }
        }
    }

    void parseWPT(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            if (var.equals("number")) {
                if (value instanceof MIConst) {
                    String str = ((MIConst)value).getString();
                    try {
                        this.number = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {}
                }
            } else if (var.equals("exp") && value instanceof MIConst) {
                this.exp = ((MIConst)value).getString();
            }
            ++i;
        }
    }

    void parseValue(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("old")) {
                this.oldValue = str;
            } else if (var.equals("new")) {
                this.newValue = str;
            }
            ++i;
        }
    }
}

