/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.index.ITagEntry;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.ICResource;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.index.CTagsRunner;
import org.eclipse.cdt.internal.core.index.RequestList;
import org.eclipse.cdt.internal.core.index.StringMatcher;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class IndexManager
implements IElementChangedListener {
    RequestList requestList = null;
    Thread thread = null;
    Map projectsMap = null;
    private static IndexManager indexManager = null;

    private IndexManager() {
    }

    public ITagEntry[] query(IProject project, String pattern, boolean ignoreCase, boolean exactMatch) {
        Map filesMap = (Map)this.projectsMap.get(project.getLocation());
        if (filesMap == null) {
            this.addContainer((IContainer)project);
        }
        ArrayList<ITagEntry> result = new ArrayList<ITagEntry>();
        filesMap = (Map)this.projectsMap.get(project.getLocation());
        if (filesMap != null) {
            if (pattern == null) {
                pattern = "*";
            }
            StringMatcher matcher = new StringMatcher(pattern, ignoreCase, exactMatch);
            Iterator values = filesMap.values().iterator();
            while (values.hasNext()) {
                ITagEntry[] entries = (ITagEntry[])values.next();
                int j = 0;
                while (j < entries.length) {
                    String tagName = entries[j].getTagName();
                    if (tagName != null && matcher.match(tagName)) {
                        result.add(entries[j]);
                    }
                    ++j;
                }
            }
        }
        return result.toArray(new ITagEntry[0]);
    }

    protected RequestList getRequestList() {
        return this.requestList;
    }

    protected Map getProjectsMap() {
        return this.projectsMap;
    }

    protected void init() {
        this.requestList = new RequestList();
        this.projectsMap = Collections.synchronizedMap(new HashMap());
        CTagsRunner ctags = new CTagsRunner(this);
        this.thread = new Thread((Runnable)ctags, "C Tags indexer");
        this.thread.setPriority(4);
        this.thread.start();
        this.addAll();
    }

    protected static void delay() {
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void removeResource(IResource resource) {
        Map filesMap = (Map)this.projectsMap.get(resource.getProject().getLocation());
        if (filesMap == null) {
            return;
        }
        switch (resource.getType()) {
            case 8: {
                break;
            }
            case 4: {
                this.projectsMap.remove(resource.getLocation());
                break;
            }
            case 2: {
                this.removeFolder((IFolder)resource);
                break;
            }
            case 1: {
                this.removeFile((IFile)resource);
            }
        }
    }

    public void removeFolder(IFolder folder) {
        Map filesMap = (Map)this.projectsMap.get(folder.getProject().getLocation());
        if (filesMap == null) {
            return;
        }
        IPath folderPath = folder.getLocation();
        if (filesMap != null) {
            Iterator keys = filesMap.keySet().iterator();
            while (keys.hasNext()) {
                IPath p = (IPath)keys.next();
                if (p == null || !folderPath.isPrefixOf(p)) continue;
                filesMap.remove(p);
            }
        }
    }

    public void removeFile(IFile file) {
        Map filesMap = (Map)this.projectsMap.get(file.getProject().getLocation());
        if (filesMap != null) {
            filesMap.remove(file.getLocation());
        }
    }

    public void addResource(IResource resource) {
        switch (resource.getType()) {
            case 2: 
            case 4: 
            case 8: {
                this.addContainer((IContainer)resource);
                break;
            }
            case 1: {
                this.addFile((IFile)resource);
            }
        }
    }

    public void addFile(IFile file) {
        CoreModel.getDefault();
        if (CoreModel.isTranslationUnit(file)) {
            this.requestList.addItem((IResource)file);
        }
    }

    public void addContainer(IContainer container) {
        if (container != null && container.exists()) {
            try {
                IResource[] resources = container.members(false);
                int i = 0;
                while (i < resources.length) {
                    IResource res = resources[i];
                    switch (res.getType()) {
                        case 8: {
                            break;
                        }
                        case 4: {
                            CoreModel.getDefault();
                            if (!CoreModel.hasCNature((IProject)res)) break;
                            this.addContainer((IContainer)res);
                            break;
                        }
                        case 2: {
                            this.addContainer((IContainer)res);
                            break;
                        }
                        case 1: {
                            this.addFile((IFile)res);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void addAll() {
        this.addResource((IResource)ResourcesPlugin.getWorkspace().getRoot());
    }

    public void saveIndexes() {
    }

    public void saveIndex(IProject project) {
    }

    public void shutdown() {
        if (this.thread != null) {
            Thread.interrupted();
        }
        CoreModel.getDefault();
        CoreModel.removeElementChangedListener(this);
    }

    public static IndexManager getDefault() {
        if (indexManager == null) {
            indexManager = new IndexManager();
            indexManager.init();
            CoreModel.getDefault();
            CoreModel.addElementChangedListener(indexManager);
        }
        return indexManager;
    }

    protected void processDelta(ICElementDelta delta) throws CModelException {
        IResource resource;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        ICElement element = delta.getElement();
        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
            // empty if block
        }
        if (kind == 2) {
            try {
                resource = ((ICResource)element).getResource();
                this.removeResource(resource);
            }
            catch (CModelException e) {
                // empty catch block
            }
        }
        if (kind == 1) {
            try {
                resource = ((ICResource)element).getResource();
                this.addResource(resource);
            }
            catch (CModelException e) {
                // empty catch block
            }
        }
        if (element instanceof ITranslationUnit && kind == 4) {
            resource = ((ICResource)element).getResource();
            this.addResource(resource);
            return;
        }
        ICElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            this.processDelta(event.getDelta());
        }
        catch (CModelException e) {
            e.printStackTrace();
        }
    }
}

