/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.spawner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.eclipse.cdt.utils.spawner.SpawnerInputStream;
import org.eclipse.cdt.utils.spawner.SpawnerOutputStream;

public class Spawner
extends Process {
    private int NOOP = 0;
    private int HUP = 1;
    private int INT = 2;
    private int KILL = 9;
    private int TERM = 15;
    int pid = 0;
    int status;
    int[] channels = new int[3];
    boolean isDone;
    OutputStream out;
    InputStream in;
    InputStream err;

    public Spawner(String command, boolean bNoRedirect) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdarray[n] = tokenizer.nextToken();
            ++n;
        }
        if (bNoRedirect) {
            this.exec_detached(cmdarray, new String[0], ".");
        } else {
            this.exec(cmdarray, new String[0], ".");
        }
    }

    protected Spawner(String[] cmdarray, String[] envp, File dir) throws IOException {
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.exec(cmdarray, envp, dirpath);
    }

    protected Spawner(String command) throws IOException {
        this(command, null);
    }

    protected Spawner(String[] cmdarray) throws IOException {
        this(cmdarray, null);
    }

    protected Spawner(String[] cmdarray, String[] envp) throws IOException {
        this(cmdarray, envp, null);
    }

    protected Spawner(String cmd, String[] envp) throws IOException {
        this(cmd, envp, null);
    }

    protected Spawner(String command, String[] envp, File dir) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(command);
        String[] cmdarray = new String[tokenizer.countTokens()];
        int n = 0;
        while (tokenizer.hasMoreTokens()) {
            cmdarray[n] = tokenizer.nextToken();
            ++n;
        }
        String dirpath = ".";
        if (dir != null) {
            dirpath = dir.getAbsolutePath();
        }
        this.exec(cmdarray, envp, dirpath);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getErrorStream() {
        return this.err;
    }

    public synchronized int waitFor() throws InterruptedException {
        while (!this.isDone) {
            this.wait();
        }
        try {
            ((SpawnerInputStream)this.getErrorStream()).close();
            ((SpawnerInputStream)this.getInputStream()).close();
            ((SpawnerOutputStream)this.getOutputStream()).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.status;
    }

    public synchronized int exitValue() {
        if (!this.isDone) {
            throw new IllegalThreadStateException("Process not Terminated");
        }
        return this.status;
    }

    public synchronized void destroy() {
        this.terminate();
        try {
            ((SpawnerInputStream)this.getErrorStream()).close();
            ((SpawnerInputStream)this.getInputStream()).close();
            ((SpawnerOutputStream)this.getOutputStream()).close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!this.isDone) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.isDone) {
            this.kill();
        }
    }

    public int interrupt() {
        return this.raise(this.pid, this.INT);
    }

    public int hangup() {
        return this.raise(this.pid, this.HUP);
    }

    public int kill() {
        return this.raise(this.pid, this.KILL);
    }

    public int terminate() {
        return this.raise(this.pid, this.TERM);
    }

    public boolean isRunning() {
        return this.raise(this.pid, this.NOOP) == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void exec(String[] cmdarray, String[] envp, String dirpath) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        Reaper reaper = new Reaper(cmdarray, envp, dirpath);
        reaper.setDaemon(true);
        reaper.start();
        Spawner spawner = this;
        // MONITORENTER : spawner
        while (this.pid == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        // MONITOREXIT : spawner
        if (this.pid == -1) {
            throw new IOException("Exec error");
        }
        this.in = new SpawnerInputStream(this.channels[1]);
        this.err = new SpawnerInputStream(this.channels[2]);
        this.out = new SpawnerOutputStream(this.channels[0]);
    }

    public void exec_detached(String[] cmdarray, String[] envp, String dirpath) throws IOException {
        String command = cmdarray[0];
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(command);
        }
        if (envp == null) {
            envp = new String[]{};
        }
        this.pid = this.exec1(cmdarray, envp, dirpath);
        if (this.pid == -1) {
            throw new IOException("Exec error");
        }
    }

    private native int exec0(String[] var1, String[] var2, String var3, int[] var4);

    private native int exec1(String[] var1, String[] var2, String var3);

    private native int raise(int var1, int var2);

    private native int waitFor(int var1);

    static {
        System.loadLibrary("spawner");
    }

    class Reaper
    extends Thread {
        String[] cmdarray;
        String[] envp;
        String dirpath;

        public Reaper(String[] array, String[] env, String dir) {
            super("Spawner Reaper");
            this.cmdarray = array;
            this.envp = env;
            this.dirpath = dir;
        }

        public void run() {
            Spawner.this.pid = Spawner.this.exec0(this.cmdarray, this.envp, this.dirpath, Spawner.this.channels);
            Spawner spawner = Spawner.this;
            synchronized (spawner) {
                Spawner.this.notifyAll();
            }
            Spawner.this.status = Spawner.this.waitFor(Spawner.this.pid);
            Spawner spawner2 = Spawner.this;
            synchronized (spawner2) {
                Spawner.this.isDone = true;
                Spawner.this.notifyAll();
            }
        }
    }
}

