/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.launch.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.AbstractCDebuggerTab;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CDebuggerTab
extends AbstractCDebuggerTab {
    protected Combo fDCombo;
    protected Button fStopInMain;
    protected Button fAttachButton;
    protected Button fRunButton;
    private final boolean DEFAULT_STOP_AT_MAIN = true;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout(2, false);
        comp.setLayout((Layout)topLayout);
        Label dlabel = new Label(comp, 0);
        dlabel.setText("Debugger:");
        this.fDCombo = new Combo(comp, 12);
        this.fDCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CDebuggerTab.super.handleDebuggerChanged();
                ICDebugConfiguration debugConfig = CDebuggerTab.this.getConfigForCurrentDebugger();
                if (debugConfig != null) {
                    CDebuggerTab.this.fRunButton.setEnabled(debugConfig.supportsMode("run"));
                    CDebuggerTab.this.fRunButton.setSelection(false);
                    CDebuggerTab.this.fAttachButton.setEnabled(debugConfig.supportsMode("attach"));
                    CDebuggerTab.this.fAttachButton.setSelection(false);
                    try {
                        String mode = CDebuggerTab.super.getLaunchConfiguration().getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_START_MODE, "run");
                        if (mode.equals("run") && CDebuggerTab.this.fRunButton.isEnabled()) {
                            CDebuggerTab.this.fRunButton.setSelection(true);
                        } else if (mode.equals("attach") && CDebuggerTab.this.fAttachButton.isEnabled()) {
                            CDebuggerTab.this.fAttachButton.setSelection(true);
                        }
                        if (CDebuggerTab.this.fRunButton.getSelection()) {
                            CDebuggerTab.this.fStopInMain.setEnabled(true);
                        } else {
                            CDebuggerTab.this.fStopInMain.setEnabled(false);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        });
        Composite radioComp = new Composite(comp, 0);
        GridLayout radioLayout = new GridLayout(2, true);
        radioLayout.marginHeight = 0;
        radioLayout.marginWidth = 0;
        radioComp.setLayout((Layout)radioLayout);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        radioComp.setLayoutData((Object)gd);
        this.fRunButton = this.createRadioButton(radioComp, "Run program in debugger.");
        this.fRunButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CDebuggerTab.this.fRunButton.getSelection()) {
                    CDebuggerTab.this.fStopInMain.setEnabled(true);
                } else {
                    CDebuggerTab.this.fStopInMain.setEnabled(false);
                }
                CDebuggerTab.super.updateLaunchConfigurationDialog();
            }
        });
        this.fAttachButton = this.createRadioButton(radioComp, "Attach to running process.");
        this.fAttachButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CDebuggerTab.super.updateLaunchConfigurationDialog();
            }
        });
        this.fStopInMain = new Button(comp, 32);
        this.fStopInMain.setText("Stop at main() on startup.");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fStopInMain.setLayoutData((Object)gd);
        Group debuggerGroup = new Group(comp, 16);
        debuggerGroup.setText("Debugger Options");
        this.setDynamicTabHolder((Composite)debuggerGroup);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration config, String selection) {
        String platform = this.getPlatform(config);
        this.fDCombo.removeAll();
        ICDebugConfiguration[] debugConfigs = CDebugCorePlugin.getDefault().getDebugConfigurations();
        int x = 0;
        int selndx = 0;
        int i = 0;
        while (i < debugConfigs.length) {
            if (debugConfigs[i].supportsMode("run") || debugConfigs[i].supportsMode("attach")) {
                String[] supported = debugConfigs[i].getPlatforms();
                boolean isLocal = platform.equals(BootLoader.getOS());
                int j = 0;
                while (j < supported.length) {
                    if (supported[j].equalsIgnoreCase(platform) || isLocal && supported[j].equalsIgnoreCase("local")) {
                        this.fDCombo.add(debugConfigs[i].getName());
                        this.fDCombo.setData(Integer.toString(x), (Object)debugConfigs[i]);
                        if (selection.equals(debugConfigs[i].getID())) {
                            selndx = x;
                        }
                        ++x;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.fDCombo.select(selndx);
        this.fDCombo.getParent().layout(true);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_STOP_AT_MAIN, true);
        config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_START_MODE, "run");
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        try {
            String id = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_ID, "");
            this.loadDebuggerComboBox(config, id);
            if (config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_STOP_AT_MAIN, true)) {
                this.fStopInMain.setSelection(true);
            }
        }
        catch (CoreException e) {
            return;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.isValid((ILaunchConfiguration)config)) {
            super.performApply(config);
            config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_STOP_AT_MAIN, false);
            if (this.fAttachButton.getSelection()) {
                config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_START_MODE, "attach");
            } else {
                config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_STOP_AT_MAIN, this.fStopInMain.getSelection());
                config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_START_MODE, "run");
            }
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (!super.isValid(config)) {
            return false;
        }
        if (!this.fRunButton.getSelection() && !this.fAttachButton.getSelection()) {
            this.setErrorMessage("Select a Debug mode.");
            return false;
        }
        return true;
    }

    protected ICDebugConfiguration getConfigForCurrentDebugger() {
        int selectedIndex = this.fDCombo.getSelectionIndex();
        return (ICDebugConfiguration)this.fDCombo.getData(Integer.toString(selectedIndex));
    }

    public String getName() {
        return "Debugger";
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_DEBUGGER_TAB);
    }
}

