/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.internal.ui.CPlugin;
import org.eclipse.cdt.internal.ui.editor.AddIncludeOnSelectionAction;
import org.eclipse.cdt.internal.ui.editor.BracketPainter;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditorErrorTickUpdater;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.CMarkerAnnotation;
import org.eclipse.cdt.internal.ui.editor.LinePainter;
import org.eclipse.cdt.internal.ui.editor.OpenOnSelectionAction;
import org.eclipse.cdt.internal.ui.editor.OverviewRuler;
import org.eclipse.cdt.internal.ui.editor.PaintManager;
import org.eclipse.cdt.internal.ui.editor.PrintMarginPainter;
import org.eclipse.cdt.internal.ui.editor.ProblemPainter;
import org.eclipse.cdt.internal.ui.editor.SearchForReferencesAction;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.util.CColorManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.tasklist.TaskList;

public class CEditor
extends AbstractTextEditor
implements ISelectionChangedListener {
    protected CContentOutlinePage fOutlinePage;
    private SearchForReferencesAction fSearchForReferencesAction;
    private Map fStatusFields;
    private boolean fInserting = true;
    private Color fForegroundColor;
    private Color fBackgroundColor;
    protected ISelectionChangedListener fStatusLineClearer;
    private PaintManager fPaintManager;
    private BracketPainter fBracketPainter;
    private LinePainter fLinePainter;
    private ProblemPainter fProblemPainter;
    private PrintMarginPainter fPrintMarginPainter;
    private TabConverter fTabConverter;
    private CEditorErrorTickUpdater fCEditorErrorTickUpdater;
    private LineNumberRulerColumn fLineNumberRulerColumn;
    public static final String CURRENT_LINE = "CEditor.currentLine";
    public static final String CURRENT_LINE_COLOR = "CEditor.currentLineColor";
    public static final String MATCHING_BRACKETS = "matchingBrackets";
    public static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public static final String MATCHING_BRACKETS_NOBOX = "matchingBracketsNobox";
    public static final String PREFERENCE_COLOR_BACKGROUND = "CEditor.preferenceColorBackground";
    public static final String PREFERENCE_COLOR_FOREGROUND = "CEditor.preferenceColorForeground";
    public static final String PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT = "CEditor.preferenceColorBackgroundDefault";
    public static final String PREFERENCE_COLOR_FOREGROUND_SYSTEM_DEFAULT = "CEditor.preferenceColorForegroundDefault";
    public static final String PROBLEM_INDICATION = "problemIndication";
    public static final String PROBLEM_INDICATION_COLOR = "problemIndicationColor";
    public static final String PRINT_MARGIN = "printMargin";
    public static final String PRINT_MARGIN_COLOR = "printMarginColor";
    public static final String PRINT_MARGIN_COLUMN = "printMarginColumn";
    public static final String SPACES_FOR_TABS = "spacesForTabs";
    public static final String LINKED_POSITION_COLOR = "linkedPositionColor";
    public static final String OVERVIEW_RULER = "overviewRuler";
    public static final String LINE_NUMBER_RULER = "lineNumberRuler";
    public static final String LINE_NUMBER_COLOR = "lineNumberColor";
    public static final String LANGUAGE_CPP = "CEditor.language.cpp";
    public static final String LANGUAGE_C = "CEditor.language.c";
    protected String fOutlinerContextMenuId;
    static /* synthetic */ Class class$org$eclipse$ui$views$contentoutline$IContentOutlinePage;

    public CEditor() {
        CTextTools textTools = CPlugin.getDefault().getTextTools();
        this.setSourceViewerConfiguration(new CSourceViewerConfiguration(textTools, this));
        this.setDocumentProvider((IDocumentProvider)CPlugin.getDefault().getDocumentProvider());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setPreferenceStore(CPlugin.getDefault().getPreferenceStore());
        this.setEditorContextMenuId("#CEditorContext");
        this.setRulerContextMenuId("#CEditorRulerContext");
        this.fCEditorErrorTickUpdater = new CEditorErrorTickUpdater(this);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.fCEditorErrorTickUpdater.setAnnotationModel(this.getDocumentProvider().getAnnotationModel((Object)input));
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    public IFile getInputFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput != null && editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        block17: {
            Shell shell = this.getSite().getShell();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath folderPath = (filePath = filePath.removeTrailingSeparator()).removeLastSegments(1);
            if (folderPath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFile(filePath);
            final FileEditorInput newInput = new FileEditorInput(file);
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws CoreException {
                    CEditor.this.getDocumentProvider().saveDocument(monitor, (Object)newInput, CEditor.this.getDocumentProvider().getDocument((Object)CEditor.this.getEditorInput()), true);
                }
            };
            boolean success = false;
            try {
                try {
                    this.getDocumentProvider().aboutToChange((Object)newInput);
                    new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)op);
                    this.setInput((IEditorInput)newInput);
                    success = true;
                }
                catch (InterruptedException x) {
                    Object var16_12 = null;
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(!success);
                    }
                    break block17;
                }
                catch (InvocationTargetException x) {
                    Throwable t = x.getTargetException();
                    if (t instanceof CoreException) {
                        CoreException cx = (CoreException)t;
                        ErrorDialog.openError((Shell)shell, (String)CEditorMessages.getString("CEditor.error.saving.title2"), (String)CEditorMessages.getString("CEditor.error.saving.message2"), (IStatus)cx.getStatus());
                    } else {
                        MessageDialog.openError((Shell)shell, (String)CEditorMessages.getString("CEditor.error.saving.title3"), (String)(CEditorMessages.getString("CEditor.error.saving.message3") + t.getMessage()));
                    }
                    Object var16_13 = null;
                    if (progressMonitor != null) {
                        progressMonitor.setCanceled(!success);
                    }
                }
                Object var16_11 = null;
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(!success);
                }
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(!success);
                }
                throw throwable;
            }
        }
    }

    public CContentOutlinePage getOutlinePage() {
        if (this.fOutlinePage == null) {
            this.fOutlinePage = new CContentOutlinePage(this);
            this.fOutlinePage.addSelectionChangedListener(this);
        }
        return this.fOutlinePage;
    }

    public Object getAdapter(Class required) {
        if ((class$org$eclipse$ui$views$contentoutline$IContentOutlinePage == null ? (class$org$eclipse$ui$views$contentoutline$IContentOutlinePage = CEditor.class$("org.eclipse.ui.views.contentoutline.IContentOutlinePage")) : class$org$eclipse$ui$views$contentoutline$IContentOutlinePage).equals(required)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(required);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        AdaptedSourceViewer asv;
        block41: {
            block56: {
                block55: {
                    block54: {
                        block53: {
                            block52: {
                                block51: {
                                    block49: {
                                        block48: {
                                            block47: {
                                                block46: {
                                                    block45: {
                                                        block44: {
                                                            block43: {
                                                                block42: {
                                                                    asv = (AdaptedSourceViewer)this.getSourceViewer();
                                                                    try {
                                                                        String property;
                                                                        block50: {
                                                                            if (asv == null) break block41;
                                                                            property = event.getProperty();
                                                                            if (PREFERENCE_COLOR_FOREGROUND.equals(property) || PREFERENCE_COLOR_FOREGROUND_SYSTEM_DEFAULT.equals(property) || PREFERENCE_COLOR_BACKGROUND.equals(property) || PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT.equals(property)) {
                                                                                this.initializeViewerColors(this.getSourceViewer());
                                                                                this.getSourceViewer().getTextWidget().redraw();
                                                                                Object var9_4 = null;
                                                                                break block42;
                                                                            }
                                                                            if (CURRENT_LINE.equals(property)) {
                                                                                if (this.isLineHighlightingEnabled()) {
                                                                                    this.startLineHighlighting();
                                                                                    break block43;
                                                                                } else {
                                                                                    this.stopLineHighlighting();
                                                                                }
                                                                                break block43;
                                                                            }
                                                                            if (CURRENT_LINE_COLOR.equals(property)) {
                                                                                if (this.fLinePainter != null) {
                                                                                    this.fLinePainter.setHighlightColor(this.getColor(CURRENT_LINE_COLOR));
                                                                                }
                                                                                break block44;
                                                                            }
                                                                            if (PROBLEM_INDICATION.equals(property)) {
                                                                                if (this.isProblemIndicationEnabled()) {
                                                                                    this.startProblemIndication();
                                                                                    break block45;
                                                                                } else {
                                                                                    this.stopProblemIndication();
                                                                                }
                                                                                break block45;
                                                                            }
                                                                            if (PROBLEM_INDICATION_COLOR.equals(property)) {
                                                                                if (this.fProblemPainter != null) {
                                                                                    this.fProblemPainter.setHighlightColor(this.getColor(PROBLEM_INDICATION_COLOR));
                                                                                }
                                                                                break block46;
                                                                            }
                                                                            if (PRINT_MARGIN.equals(property)) {
                                                                                if (this.isShowingPrintMarginEnabled()) {
                                                                                    this.startShowingPrintMargin();
                                                                                    break block47;
                                                                                } else {
                                                                                    this.stopShowingPrintMargin();
                                                                                }
                                                                                break block47;
                                                                            }
                                                                            if (PRINT_MARGIN_COLOR.equals(property)) {
                                                                                if (this.fPrintMarginPainter != null) {
                                                                                    this.fPrintMarginPainter.setMarginRulerColor(this.getColor(PRINT_MARGIN_COLOR));
                                                                                }
                                                                                break block48;
                                                                            }
                                                                            if (PRINT_MARGIN_COLUMN.equals(property)) {
                                                                                if (this.fPrintMarginPainter != null) {
                                                                                    this.fPrintMarginPainter.setMarginRulerColumn(this.getPreferenceStore().getInt(PRINT_MARGIN_COLUMN));
                                                                                }
                                                                                break block49;
                                                                            }
                                                                            if ("org.eclipse.cdt.editor.tab.width".equals(property)) {
                                                                                Object value;
                                                                                SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
                                                                                String[] types = configuration.getConfiguredContentTypes((ISourceViewer)asv);
                                                                                int i = 0;
                                                                                while (true) {
                                                                                    if (i >= types.length) {
                                                                                        if (this.fTabConverter != null) {
                                                                                            this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("org.eclipse.cdt.editor.tab.width"));
                                                                                        }
                                                                                        if (!((value = event.getNewValue()) instanceof Integer)) break;
                                                                                        asv.getTextWidget().setTabs(((Integer)value).intValue());
                                                                                        break block50;
                                                                                    }
                                                                                    asv.setIndentPrefixes(configuration.getIndentPrefixes((ISourceViewer)asv, types[i]), types[i]);
                                                                                    ++i;
                                                                                }
                                                                                if (value instanceof String) {
                                                                                    asv.getTextWidget().setTabs(Integer.parseInt((String)value));
                                                                                }
                                                                            }
                                                                        }
                                                                        if (SPACES_FOR_TABS.equals(property)) {
                                                                            if (this.isTabConversionEnabled()) {
                                                                                this.startTabConversion();
                                                                                break block51;
                                                                            } else {
                                                                                this.stopTabConversion();
                                                                            }
                                                                            break block51;
                                                                        }
                                                                        if (MATCHING_BRACKETS.equals(property)) {
                                                                            if (this.isBracketHighlightingEnabled()) {
                                                                                this.startBracketHighlighting();
                                                                                break block52;
                                                                            } else {
                                                                                this.stopBracketHighlighting();
                                                                            }
                                                                            break block52;
                                                                        }
                                                                        if (MATCHING_BRACKETS_COLOR.equals(property)) {
                                                                            if (this.fBracketPainter != null) {
                                                                                this.fBracketPainter.setHighlightColor(this.getColor(MATCHING_BRACKETS_COLOR));
                                                                            }
                                                                            break block53;
                                                                        }
                                                                        if (MATCHING_BRACKETS_NOBOX.equals(property)) {
                                                                            if (this.isBracketHighlightingEnabled()) {
                                                                                this.setBracketHighlightingStyle();
                                                                            }
                                                                            break block54;
                                                                        }
                                                                        if (LINE_NUMBER_RULER.equals(property)) {
                                                                            if (this.isLineNumberRulerVisible()) {
                                                                                this.showLineNumberRuler();
                                                                                break block55;
                                                                            } else {
                                                                                this.hideLineNumberRuler();
                                                                            }
                                                                            break block55;
                                                                        }
                                                                        if (this.fLineNumberRulerColumn != null && (LINE_NUMBER_COLOR.equals(property) || PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT.equals(property) || PREFERENCE_COLOR_BACKGROUND.equals(property))) {
                                                                            this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
                                                                        }
                                                                        if (!OVERVIEW_RULER.equals(property)) break block41;
                                                                        if (this.isOverviewRulerVisible()) {
                                                                            this.showOverviewRuler();
                                                                            break block56;
                                                                        } else {
                                                                            this.hideOverviewRuler();
                                                                        }
                                                                        break block56;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        Object var9_19 = null;
                                                                        super.handlePreferenceStoreChanged(event);
                                                                        if (asv == null) throw throwable;
                                                                        if (!this.affectsTextPresentation(event)) throw throwable;
                                                                        asv.invalidateTextPresentation();
                                                                        throw throwable;
                                                                    }
                                                                }
                                                                super.handlePreferenceStoreChanged(event);
                                                                if (asv == null) return;
                                                                if (!this.affectsTextPresentation(event)) return;
                                                                asv.invalidateTextPresentation();
                                                                return;
                                                            }
                                                            Object var9_5 = null;
                                                            super.handlePreferenceStoreChanged(event);
                                                            if (asv == null) return;
                                                            if (!this.affectsTextPresentation(event)) return;
                                                            asv.invalidateTextPresentation();
                                                            return;
                                                        }
                                                        Object var9_6 = null;
                                                        super.handlePreferenceStoreChanged(event);
                                                        if (asv == null) return;
                                                        if (!this.affectsTextPresentation(event)) return;
                                                        asv.invalidateTextPresentation();
                                                        return;
                                                    }
                                                    Object var9_7 = null;
                                                    super.handlePreferenceStoreChanged(event);
                                                    if (asv == null) return;
                                                    if (!this.affectsTextPresentation(event)) return;
                                                    asv.invalidateTextPresentation();
                                                    return;
                                                }
                                                Object var9_8 = null;
                                                super.handlePreferenceStoreChanged(event);
                                                if (asv == null) return;
                                                if (!this.affectsTextPresentation(event)) return;
                                                asv.invalidateTextPresentation();
                                                return;
                                            }
                                            Object var9_9 = null;
                                            super.handlePreferenceStoreChanged(event);
                                            if (asv == null) return;
                                            if (!this.affectsTextPresentation(event)) return;
                                            asv.invalidateTextPresentation();
                                            return;
                                        }
                                        Object var9_10 = null;
                                        super.handlePreferenceStoreChanged(event);
                                        if (asv == null) return;
                                        if (!this.affectsTextPresentation(event)) return;
                                        asv.invalidateTextPresentation();
                                        return;
                                    }
                                    Object var9_11 = null;
                                    super.handlePreferenceStoreChanged(event);
                                    if (asv == null) return;
                                    if (!this.affectsTextPresentation(event)) return;
                                    asv.invalidateTextPresentation();
                                    return;
                                }
                                Object var9_12 = null;
                                super.handlePreferenceStoreChanged(event);
                                if (asv == null) return;
                                if (!this.affectsTextPresentation(event)) return;
                                asv.invalidateTextPresentation();
                                return;
                            }
                            Object var9_13 = null;
                            super.handlePreferenceStoreChanged(event);
                            if (asv == null) return;
                            if (!this.affectsTextPresentation(event)) return;
                            asv.invalidateTextPresentation();
                            return;
                        }
                        Object var9_14 = null;
                        super.handlePreferenceStoreChanged(event);
                        if (asv == null) return;
                        if (!this.affectsTextPresentation(event)) return;
                        asv.invalidateTextPresentation();
                        return;
                    }
                    Object var9_15 = null;
                    super.handlePreferenceStoreChanged(event);
                    if (asv == null) return;
                    if (!this.affectsTextPresentation(event)) return;
                    asv.invalidateTextPresentation();
                    return;
                }
                Object var9_16 = null;
                super.handlePreferenceStoreChanged(event);
                if (asv == null) return;
                if (!this.affectsTextPresentation(event)) return;
                asv.invalidateTextPresentation();
                return;
            }
            Object var9_17 = null;
            super.handlePreferenceStoreChanged(event);
            if (asv == null) return;
            if (!this.affectsTextPresentation(event)) return;
            asv.invalidateTextPresentation();
            return;
        }
        Object var9_18 = null;
        super.handlePreferenceStoreChanged(event);
        if (asv == null) return;
        if (!this.affectsTextPresentation(event)) return;
        asv.invalidateTextPresentation();
    }

    private void initializeViewerColors(ISourceViewer viewer) {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = store.getBoolean(PREFERENCE_COLOR_FOREGROUND_SYSTEM_DEFAULT) ? null : this.createColor(store, PREFERENCE_COLOR_FOREGROUND, styledText.getDisplay());
            styledText.setForeground(color);
            if (this.fForegroundColor != null) {
                this.fForegroundColor.dispose();
            }
            this.fForegroundColor = color;
            color = store.getBoolean(PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT) ? null : this.createColor(store, PREFERENCE_COLOR_BACKGROUND, styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection;
        Object obj;
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection && (obj = (selection = (IStructuredSelection)sel).getFirstElement()) instanceof ISourceReference) {
            try {
                ISourceRange range = ((ISourceReference)obj).getSourceRange();
                if (range != null) {
                    this.setSelection(range, !this.isActivePart());
                }
            }
            catch (CModelException e) {
                // empty catch block
            }
        }
    }

    private void setSelection(ISourceRange element, boolean moveCursor) {
        if (element != null) {
            try {
                int start = element.getStartPos();
                int length = element.getLength();
                this.setHighlightRange(start, length, moveCursor);
                if (moveCursor) {
                    start = element.getIdStartPos();
                    if (start > -1) {
                        length = element.getIdLength();
                        if (this.getSourceViewer() != null) {
                            this.getSourceViewer().revealRange(start, length);
                            this.getSourceViewer().setSelectedRange(start, length);
                        }
                    }
                    this.updateStatusField("CursorPosition");
                }
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (moveCursor) {
            this.resetHighlightRange();
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        return this == service.getActivePart();
    }

    public void dispose() {
        this.stopBracketHighlighting();
        this.stopLineHighlighting();
        if (this.fPaintManager != null) {
            this.fPaintManager.dispose();
            this.fPaintManager = null;
        }
        if (this.fCEditorErrorTickUpdater != null) {
            this.fCEditorErrorTickUpdater.setAnnotationModel(null);
            this.fCEditorErrorTickUpdater = null;
        }
        super.dispose();
    }

    protected void createActions() {
        super.createActions();
        this.setAction("Comment", (IAction)new TextOperationAction(CEditorMessages.getResourceBundle(), "Comment.", (ITextEditor)this, 11));
        this.setAction("Uncomment", (IAction)new TextOperationAction(CEditorMessages.getResourceBundle(), "Uncomment.", (ITextEditor)this, 12));
        this.setAction("Format", (IAction)new TextOperationAction(CEditorMessages.getResourceBundle(), "Format.", (ITextEditor)this, 15));
        this.setAction("ContentAssistProposal", (IAction)new TextOperationAction(CEditorMessages.getResourceBundle(), "ContentAssistProposal.", (ITextEditor)this, 13));
        this.setAction("AddIncludeOnSelection", (IAction)new AddIncludeOnSelectionAction((ITextEditor)this));
        this.setAction("OpenOnSelection", (IAction)new OpenOnSelectionAction(this));
        this.fSearchForReferencesAction = new SearchForReferencesAction(this.getSelectionProvider());
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        this.addGroup(menu, "group.edit", "group.reorganize");
        this.addGroup(menu, "group.edit", "group.generate");
        this.addGroup(menu, "group.edit", "group.new");
        this.addAction(menu, "group.edit", "Comment");
        this.addAction(menu, "group.edit", "Uncomment");
        MenuManager search = new MenuManager("Search", "group.search");
        menu.appendToGroup("group.find", (IContributionItem)search);
        if (SearchForReferencesAction.canActionBeAdded(this.getSelectionProvider().getSelection())) {
            search.add((IAction)this.fSearchForReferencesAction);
        }
        this.addAction(menu, "group.generate", "ContentAssistProposal");
        this.addAction(menu, "group.generate", "AddIncludeOnSelection");
        this.addAction(menu, "group.generate", "OpenOnSelection");
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fPaintManager = new PaintManager(this.getSourceViewer());
        ISelectionChangedListener sListener = new ISelectionChangedListener(){
            private Runnable fRunnable = new Runnable(this){
                private final /* synthetic */ 2 this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    CEditor.access$101(2.access$000(this.this$1), "CursorPosition");
                }
            };
            private Display fDisplay;

            public void selectionChanged(SelectionChangedEvent event) {
                if (this.fDisplay == null) {
                    this.fDisplay = CEditor.this.getSite().getShell().getDisplay();
                }
                this.fDisplay.asyncExec(this.fRunnable);
            }

            static /* synthetic */ CEditor access$000(2 x0) {
                return x0.CEditor.this;
            }
        };
        this.getSelectionProvider().addSelectionChangedListener(sListener);
        this.initializeViewerColors(this.getSourceViewer());
        if (this.isLineHighlightingEnabled()) {
            this.startLineHighlighting();
        }
        if (this.isProblemIndicationEnabled()) {
            this.startProblemIndication();
        }
        if (this.isShowingPrintMarginEnabled()) {
            this.startShowingPrintMargin();
        }
        if (this.isTabConversionEnabled()) {
            this.startTabConversion();
        }
        if (this.isBracketHighlightingEnabled()) {
            this.startBracketHighlighting();
        }
    }

    private Color getColor(String key) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)key);
        return this.getColor(rgb);
    }

    private Color getColor(RGB rgb) {
        CTextTools textTools = CPlugin.getDefault().getTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private IMarker getNextError(int offset, boolean forward) {
        IMarker nextError = null;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = 0;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position p;
            MarkerAnnotation ma;
            IMarker marker;
            Annotation a = (Annotation)e.next();
            if (!(a instanceof CMarkerAnnotation) || !MarkerUtilities.isMarkerType((IMarker)(marker = (ma = (MarkerAnnotation)a).getMarker()), (String)"org.eclipse.core.resources.problemmarker") || (p = model.getPosition(a)).includes(offset)) continue;
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument - offset + p.getOffset();
                }
            } else {
                currentDistance = offset - p.getOffset();
                if (currentDistance < 0) {
                    currentDistance = offset + endOfDocument - p.getOffset();
                }
            }
            if (nextError != null && (currentDistance >= distance || currentDistance == 0)) continue;
            distance = currentDistance;
            if (distance == 0) {
                distance = endOfDocument;
            }
            nextError = marker;
        }
        return nextError;
    }

    public void gotoError(boolean forward) {
        ITextSelection s;
        IMarker nextError;
        ISelectionProvider provider = this.getSelectionProvider();
        if (this.fStatusLineClearer != null) {
            provider.removeSelectionChangedListener(this.fStatusLineClearer);
            this.fStatusLineClearer = null;
        }
        if ((nextError = this.getNextError((s = (ITextSelection)provider.getSelection()).getOffset(), forward)) != null) {
            this.gotoMarker(nextError);
            IWorkbenchPage page = this.getSite().getPage();
            IViewPart view = page.findView("org.eclipse.ui.views.TaskList");
            if (view instanceof TaskList) {
                StructuredSelection ss = new StructuredSelection((Object)nextError);
                ((TaskList)view).setSelection((ISelection)ss, true);
            }
            this.getStatusLineManager().setErrorMessage(nextError.getAttribute("message", ""));
            this.fStatusLineClearer = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CEditor.this.getSelectionProvider().removeSelectionChangedListener(CEditor.this.fStatusLineClearer);
                    CEditor.this.fStatusLineClearer = null;
                    CEditor.this.getStatusLineManager().setErrorMessage("");
                }
            };
            provider.addSelectionChangedListener(this.fStatusLineClearer);
        } else {
            this.getStatusLineManager().setErrorMessage("");
        }
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    private void startLineHighlighting() {
        if (this.fLinePainter == null) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            this.fLinePainter = new LinePainter(sourceViewer);
            this.fLinePainter.setHighlightColor(this.getColor(CURRENT_LINE_COLOR));
            this.fPaintManager.addPainter(this.fLinePainter);
        }
    }

    private void stopLineHighlighting() {
        if (this.fLinePainter != null) {
            this.fPaintManager.removePainter(this.fLinePainter);
            this.fLinePainter.deactivate(true);
            this.fLinePainter.dispose();
            this.fLinePainter = null;
        }
    }

    private boolean isLineHighlightingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(CURRENT_LINE);
    }

    private void startProblemIndication() {
        if (this.fProblemPainter == null) {
            this.fProblemPainter = new ProblemPainter((ITextEditor)this, this.getSourceViewer());
            this.fProblemPainter.setHighlightColor(this.getColor(PROBLEM_INDICATION_COLOR));
            this.fPaintManager.addPainter(this.fProblemPainter);
        }
    }

    private void stopProblemIndication() {
        if (this.fProblemPainter != null) {
            this.fPaintManager.removePainter(this.fProblemPainter);
            this.fProblemPainter.deactivate(true);
            this.fProblemPainter.dispose();
            this.fProblemPainter = null;
        }
    }

    private boolean isProblemIndicationEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(PROBLEM_INDICATION);
    }

    private void startShowingPrintMargin() {
        if (this.fPrintMarginPainter == null) {
            this.fPrintMarginPainter = new PrintMarginPainter(this.getSourceViewer());
            this.fPrintMarginPainter.setMarginRulerColor(this.getColor(PRINT_MARGIN_COLOR));
            this.fPrintMarginPainter.setMarginRulerColumn(this.getPreferenceStore().getInt(PRINT_MARGIN_COLUMN));
            this.fPaintManager.addPainter(this.fPrintMarginPainter);
        }
    }

    private void stopShowingPrintMargin() {
        if (this.fPrintMarginPainter != null) {
            this.fPaintManager.removePainter(this.fPrintMarginPainter);
            this.fPrintMarginPainter.deactivate(true);
            this.fPrintMarginPainter.dispose();
            this.fPrintMarginPainter = null;
        }
    }

    private boolean isShowingPrintMarginEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(PRINT_MARGIN);
    }

    private void startTabConversion() {
        if (this.fTabConverter == null) {
            this.fTabConverter = new TabConverter();
            this.fTabConverter.setNumberOfSpacesPerTab(this.getPreferenceStore().getInt("org.eclipse.cdt.editor.tab.width"));
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            asv.addTextConverter(this.fTabConverter);
        }
    }

    private void stopTabConversion() {
        if (this.fTabConverter != null) {
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            asv.removeTextConverter(this.fTabConverter);
            this.fTabConverter = null;
        }
    }

    private boolean isTabConversionEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(SPACES_FOR_TABS);
    }

    private void startBracketHighlighting() {
        if (this.fBracketPainter == null) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            this.fBracketPainter = new BracketPainter(sourceViewer);
            this.fBracketPainter.setHighlightColor(this.getColor(MATCHING_BRACKETS_COLOR));
            this.fPaintManager.addPainter(this.fBracketPainter);
            IPreferenceStore store = this.getPreferenceStore();
            this.fBracketPainter.setHighlightStyle(store.getBoolean(MATCHING_BRACKETS_NOBOX));
        }
    }

    private void stopBracketHighlighting() {
        if (this.fBracketPainter != null) {
            this.fPaintManager.removePainter(this.fBracketPainter);
            this.fBracketPainter.deactivate(true);
            this.fBracketPainter.dispose();
            this.fBracketPainter = null;
        }
    }

    private boolean isBracketHighlightingEnabled() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(MATCHING_BRACKETS);
    }

    private void setBracketHighlightingStyle() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.fBracketPainter != null) {
            this.fBracketPainter.setHighlightStyle(store.getBoolean(MATCHING_BRACKETS_NOBOX));
        }
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        String filename = this.getEditorInput().getName();
        boolean c_file = false;
        c_file |= filename.endsWith(".c");
        return new AdaptedSourceViewer(parent, ruler, styles, (c_file |= filename.endsWith(".h")) ? LANGUAGE_C : LANGUAGE_CPP);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        String p = event.getProperty();
        boolean affects = MATCHING_BRACKETS_COLOR.equals(p) || CURRENT_LINE_COLOR.equals(p) || PROBLEM_INDICATION_COLOR.equals(p);
        CTextTools textTools = CPlugin.getDefault().getTextTools();
        return (affects |= textTools.affectsBehavior(event)) ? affects : super.affectsTextPresentation(event);
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.fLineNumberRulerColumn = new LineNumberRulerColumn();
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12));
        if (this.isLineNumberRulerVisible()) {
            ruler.addDecorator(1, this.createLineNumberRulerColumn());
        }
        return ruler;
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn rulerColumn) {
        CTextTools textTools = CPlugin.getDefault().getTextTools();
        CColorManager manager = textTools.getColorManager();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            RGB rgb = null;
            if (store.contains(LINE_NUMBER_COLOR)) {
                rgb = store.isDefault(LINE_NUMBER_COLOR) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)LINE_NUMBER_COLOR) : PreferenceConverter.getColor((IPreferenceStore)store, (String)LINE_NUMBER_COLOR);
            }
            rulerColumn.setForeground(manager.getColor(rgb));
            rgb = null;
            if (!store.getBoolean(PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT) && store.contains(PREFERENCE_COLOR_BACKGROUND)) {
                rgb = store.isDefault(PREFERENCE_COLOR_BACKGROUND) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)PREFERENCE_COLOR_BACKGROUND) : PreferenceConverter.getColor((IPreferenceStore)store, (String)PREFERENCE_COLOR_BACKGROUND);
            }
            rulerColumn.setBackground(manager.getColor(rgb));
        }
    }

    private void showLineNumberRuler() {
        IVerticalRuler v = this.getVerticalRuler();
        if (v instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.addDecorator(1, this.createLineNumberRulerColumn());
        }
    }

    private void hideLineNumberRuler() {
        IVerticalRuler v = this.getVerticalRuler();
        if (v instanceof CompositeRuler) {
            CompositeRuler c = (CompositeRuler)v;
            c.removeDecorator(1);
        }
    }

    private boolean isLineNumberRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(LINE_NUMBER_RULER);
    }

    private void showOverviewRuler() {
        AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
        asv.showOverviewRuler();
    }

    private void hideOverviewRuler() {
        AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
        asv.hideOverviewRuler();
    }

    private boolean isOverviewRulerVisible() {
        IPreferenceStore store = this.getPreferenceStore();
        return store.getBoolean(OVERVIEW_RULER);
    }

    protected void setOutlinerContextMenuId(String menuId) {
        this.fOutlinerContextMenuId = menuId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$101(CEditor x0, String x1) {
        super.updateStatusField(x1);
    }

    public class AdaptedSourceViewer
    extends SourceViewer
    implements ITextViewerExtension {
        private List fTextConverters;
        private String fDisplayLanguage;
        private OverviewRuler fOverviewRuler;
        private boolean fIsOverviewRulerVisible;
        private IVerticalRuler fCachedVerticalRuler;
        private boolean fCachedIsVerticalRulerVisible;
        private VerifyKeyListenersManager fVerifyKeyListenersManager = new VerifyKeyListenersManager();

        public AdaptedSourceViewer(Composite parent, IVerticalRuler ruler, int styles, String language) {
            super(parent, ruler, styles);
            this.fDisplayLanguage = language;
            this.fCachedVerticalRuler = ruler;
            this.fCachedIsVerticalRulerVisible = ruler != null;
            this.fOverviewRuler = new OverviewRuler(12);
            this.delayedCreateControl(parent, styles);
        }

        public void showAnnotations(boolean show) {
            this.fCachedIsVerticalRulerVisible = show && this.fCachedVerticalRuler != null;
            super.showAnnotations(show);
        }

        public void doOperation(int operation) {
            if (this.getTextWidget() == null) {
                return;
            }
            super.doOperation(operation);
        }

        public void insertTextConverter(ITextConverter textConverter, int index) {
            throw new UnsupportedOperationException();
        }

        public void addTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters == null) {
                this.fTextConverters = new ArrayList(1);
                this.fTextConverters.add(textConverter);
            } else if (!this.fTextConverters.contains(textConverter)) {
                this.fTextConverters.add(textConverter);
            }
        }

        public void removeTextConverter(ITextConverter textConverter) {
            if (this.fTextConverters != null) {
                this.fTextConverters.remove(textConverter);
                if (this.fTextConverters.size() == 0) {
                    this.fTextConverters = null;
                }
            }
        }

        protected void customizeDocumentCommand(DocumentCommand command) {
            super.customizeDocumentCommand(command);
            if (this.fTextConverters != null) {
                Iterator e = this.fTextConverters.iterator();
                while (e.hasNext()) {
                    ((ITextConverter)e.next()).customizeDocumentCommand(this.getDocument(), command);
                }
            }
        }

        public IVerticalRuler getVerticalRuler() {
            return this.fCachedVerticalRuler;
        }

        public boolean isVerticalRulerVisible() {
            return this.fCachedIsVerticalRulerVisible;
        }

        public OverviewRuler getOverviewRuler() {
            return this.fOverviewRuler;
        }

        protected void createControl(Composite parent, int styles) {
        }

        protected void delayedCreateControl(Composite parent, int styles) {
            super.createControl(parent, styles);
            Control control = this.getControl();
            if (control instanceof Composite) {
                Composite composite = (Composite)control;
                composite.setLayout((Layout)new AdaptedRulerLayout(2, this));
                this.fOverviewRuler.createControl(composite, (ITextViewer)this);
            }
        }

        public void hideOverviewRuler() {
            this.fIsOverviewRulerVisible = false;
            Control control = this.getControl();
            if (control instanceof Composite) {
                Composite composite = (Composite)control;
                composite.layout();
            }
        }

        public void showOverviewRuler() {
            this.fIsOverviewRulerVisible = true;
            Control control = this.getControl();
            if (control instanceof Composite) {
                Composite composite = (Composite)control;
                composite.layout();
            }
        }

        public boolean isOverviewRulerVisible() {
            return this.fIsOverviewRulerVisible;
        }

        public void setDocument(IDocument document, IAnnotationModel annotationModel, int visibleRegionOffset, int visibleRegionLength) {
            super.setDocument(document, annotationModel, visibleRegionOffset, visibleRegionLength);
            this.fOverviewRuler.setModel(annotationModel);
        }

        public void setDisplayLanguage(String language) {
            this.fDisplayLanguage = language;
        }

        public String getDisplayLanguage() {
            return this.fDisplayLanguage;
        }

        public void appendVerifyKeyListener(VerifyKeyListener listener) {
            int index = this.fVerifyKeyListenersManager.numberOfListeners();
            this.fVerifyKeyListenersManager.insertListener(listener, index);
        }

        public void prependVerifyKeyListener(VerifyKeyListener listener) {
            this.fVerifyKeyListenersManager.insertListener(listener, 0);
        }

        public void removeVerifyKeyListener(VerifyKeyListener listener) {
            this.fVerifyKeyListenersManager.removeListener(listener);
        }

        class VerifyKeyListenersManager
        implements VerifyKeyListener {
            private List fListeners = new ArrayList();
            private List fBatched = new ArrayList();
            private Iterator fIterator;

            VerifyKeyListenersManager() {
            }

            public void verifyKey(VerifyEvent event) {
                if (this.fListeners.isEmpty()) {
                    return;
                }
                this.fIterator = this.fListeners.iterator();
                while (this.fIterator.hasNext() && event.doit) {
                    VerifyKeyListener listener = (VerifyKeyListener)this.fIterator.next();
                    listener.verifyKey(event);
                }
                this.fIterator = null;
                this.processBatchedRequests();
            }

            private void processBatchedRequests() {
                if (!this.fBatched.isEmpty()) {
                    Iterator e = this.fBatched.iterator();
                    while (e.hasNext()) {
                        Batch batch = (Batch)e.next();
                        this.insertListener(batch.listener, batch.index);
                    }
                    this.fBatched.clear();
                }
            }

            public int numberOfListeners() {
                return this.fListeners.size();
            }

            public void insertListener(VerifyKeyListener listener, int index) {
                if (index == -1) {
                    this.removeListener(listener);
                } else if (listener != null) {
                    if (this.fIterator != null) {
                        this.fBatched.add(new Batch(listener, index));
                    } else {
                        int idx = this.fListeners.indexOf(listener);
                        if (idx != index) {
                            if (idx != -1) {
                                this.fListeners.remove(idx);
                            }
                            if (index > this.fListeners.size()) {
                                this.fListeners.add(listener);
                            } else {
                                this.fListeners.add(index, listener);
                            }
                        }
                        if (this.fListeners.size() == 1) {
                            this.install();
                        }
                    }
                }
            }

            public void removeListener(VerifyKeyListener listener) {
                if (listener == null) {
                    return;
                }
                if (this.fIterator != null) {
                    this.fBatched.add(new Batch(listener, -1));
                } else {
                    this.fListeners.remove(listener);
                    if (this.fListeners.isEmpty()) {
                        this.uninstall();
                    }
                }
            }

            private void install() {
                AdaptedSourceViewer.this.getTextWidget().addVerifyKeyListener((VerifyKeyListener)this);
            }

            private void uninstall() {
                StyledText textWidget = AdaptedSourceViewer.this.getTextWidget();
                if (textWidget != null && !textWidget.isDisposed()) {
                    textWidget.removeVerifyKeyListener((VerifyKeyListener)this);
                }
            }

            class Batch {
                int index;
                VerifyKeyListener listener;

                public Batch(VerifyKeyListener l, int i) {
                    this.listener = l;
                    this.index = i;
                }
            }
        }

        class TextVerifyListener
        implements VerifyListener {
            private boolean fForward = true;

            TextVerifyListener() {
            }

            public void forward(boolean forward) {
                this.fForward = forward;
            }

            public void verifyText(VerifyEvent e) {
                if (this.fForward) {
                    AdaptedSourceViewer.super.handleVerifyEvent(e);
                }
            }
        }
    }

    class AdaptedRulerLayout
    extends Layout {
        protected int fGap;
        protected AdaptedSourceViewer fAdaptedSourceViewer;

        protected AdaptedRulerLayout(int gap, AdaptedSourceViewer asv) {
            this.fGap = gap;
            this.fAdaptedSourceViewer = asv;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            Point s = children[children.length - 1].computeSize(-1, -1, flushCache);
            if (this.fAdaptedSourceViewer.isVerticalRulerVisible()) {
                s.x += this.fAdaptedSourceViewer.getVerticalRuler().getWidth() + this.fGap;
            }
            return s;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clArea = composite.getClientArea();
            if (this.fAdaptedSourceViewer.isVerticalRulerVisible()) {
                StyledText textWidget = this.fAdaptedSourceViewer.getTextWidget();
                Rectangle trim = textWidget.computeTrim(0, 0, 0, 0);
                int scrollbarHeight = trim.height;
                IVerticalRuler vr = this.fAdaptedSourceViewer.getVerticalRuler();
                int vrWidth = vr.getWidth();
                int orWidth = 0;
                if (this.fAdaptedSourceViewer.isOverviewRulerVisible()) {
                    OverviewRuler or = this.fAdaptedSourceViewer.getOverviewRuler();
                    orWidth = or.getWidth();
                    or.getControl().setBounds(clArea.width - orWidth, scrollbarHeight, orWidth, clArea.height - 3 * scrollbarHeight);
                }
                textWidget.setBounds(vrWidth + this.fGap, 0, clArea.width - vrWidth - orWidth - 2 * this.fGap, clArea.height);
                vr.getControl().setBounds(0, 0, vrWidth, clArea.height - scrollbarHeight);
            } else {
                StyledText textWidget = this.fAdaptedSourceViewer.getTextWidget();
                textWidget.setBounds(0, 0, clArea.width, clArea.height);
            }
        }
    }

    static class TabConverter
    implements ITextConverter {
        private String fTabString = "";

        TabConverter() {
        }

        public void setNumberOfSpacesPerTab(int ratio) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < ratio) {
                buffer.append(' ');
                ++i;
            }
            this.fTabString = buffer.toString();
        }

        public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
            int index;
            String text = command.text;
            if (text != null && (index = text.indexOf(9)) > -1) {
                int length = text.length();
                StringBuffer buffer = new StringBuffer();
                buffer.append(text.substring(0, index));
                int i = index;
                while (i < length) {
                    char c = text.charAt(i);
                    if (c == '\t') {
                        buffer.append(this.fTabString);
                    } else {
                        buffer.append(c);
                    }
                    ++i;
                }
                command.text = buffer.toString();
            }
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    static interface ICursorListener
    extends MouseListener,
    KeyListener {
    }
}

