/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.dialogfields;

import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.swt.MGridData;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class DialogField {
    private Label fLabel = null;
    protected String fLabelText = "";
    private IDialogFieldListener fDialogFieldListener;
    private boolean fEnabled = true;

    protected final void assertCompositeNotNull(Composite comp) {
        Assert.isNotNull((Object)comp, (String)"uncreated control requested with composite null");
    }

    protected final void assertEnoughColumns(int nColumns) {
        Assert.isTrue((nColumns >= this.getNumberOfControls() ? 1 : 0) != 0, (String)"given number of columns is too small");
    }

    public static Control createEmptySpace(Composite parent, int span) {
        Label label = new Label(parent, 16384);
        MGridData gd = new MGridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    public static Control createEmptySpace(Composite parent) {
        return DialogField.createEmptySpace(parent, 1);
    }

    public void dialogFieldChanged() {
        if (this.fDialogFieldListener != null) {
            this.fDialogFieldListener.dialogFieldChanged(this);
        }
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)DialogField.gridDataForLabel(nColumns));
        return new Control[]{label};
    }

    public Label getLabelControl(Composite parent) {
        if (this.fLabel == null) {
            this.assertCompositeNotNull(parent);
            this.fLabel = new Label(parent, 16384);
            this.fLabel.setFont(parent.getFont());
            this.fLabel.setEnabled(this.fEnabled);
            if (this.fLabelText != null && !"".equals(this.fLabelText)) {
                this.fLabel.setText(this.fLabelText);
            } else {
                this.fLabel.setText(".");
                this.fLabel.setVisible(false);
            }
        }
        return this.fLabel;
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected static MGridData gridDataForLabel(int span) {
        MGridData gd = new MGridData();
        gd.horizontalSpan = span;
        return gd;
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    protected boolean isOkToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public void postSetFocusOnDialogField(Display display) {
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    DialogField.this.setFocus();
                }
            });
        }
    }

    public void setDialogFieldListener(IDialogFieldListener listener) {
        this.fDialogFieldListener = listener;
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.fEnabled) {
            this.fEnabled = enabled;
            this.updateEnableState();
        }
    }

    public boolean setFocus() {
        return false;
    }

    public void setLabelText(String labeltext) {
        this.fLabelText = labeltext;
    }

    protected void updateEnableState() {
        if (this.fLabel != null) {
            this.fLabel.setEnabled(this.fEnabled);
        }
    }
}

