/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.IRunToLine;
import org.eclipse.cdt.debug.internal.ui.actions.AbstractEditorActionDelegate;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineActionDelegate
extends AbstractEditorActionDelegate {
    public void run(IAction action) {
        IFile file;
        IEditorInput input;
        if (this.getTargetPart() != null && this.getTargetPart() instanceof ITextEditor && (input = ((ITextEditor)this.getTargetPart()).getEditorInput()) != null && input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            ITextSelection selection = (ITextSelection)((ITextEditor)this.getTargetPart()).getSelectionProvider().getSelection();
            int lineNumber = selection.getStartLine() + 1;
            this.runToLine((IResource)file, lineNumber);
        }
    }

    protected void initializeDebugTarget() {
        IDebugTarget target;
        this.setDebugTarget(null);
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null && context instanceof IDebugElement && (target = ((IDebugElement)context).getDebugTarget()) != null && target instanceof IRunToLine) {
            this.setDebugTarget(target);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IDebugTarget target = null;
        if (part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
            IDebugTarget target1;
            Object element;
            if (selection != null && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null && element instanceof IDebugElement && (target1 = ((IDebugElement)element).getDebugTarget()) != null && target1 instanceof IRunToLine) {
                target = target1;
            }
            this.setDebugTarget(target);
            this.update();
        }
    }

    protected void runToLine(IResource resource, int lineNumber) {
        if (!((IRunToLine)this.getDebugTarget()).canRunToLine(resource, lineNumber)) {
            this.getTargetPart().getSite().getShell().getDisplay().beep();
            return;
        }
        try {
            ((IRunToLine)this.getDebugTarget()).runToLine(resource, lineNumber);
        }
        catch (DebugException e) {
            CDebugUIPlugin.errorDialog(e.getMessage(), e);
        }
    }
}

