/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.io.File;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIInstruction;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.Instruction;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataDisassemble;
import org.eclipse.cdt.debug.mi.core.command.MIEnvironmentDirectory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetAutoSolib;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSetSolibSearchPath;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowDirectories;
import org.eclipse.cdt.debug.mi.core.command.MIGDBShowSolibSearchPath;
import org.eclipse.cdt.debug.mi.core.output.MIAsm;
import org.eclipse.cdt.debug.mi.core.output.MIDataDisassembleInfo;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowDirectoriesInfo;
import org.eclipse.cdt.debug.mi.core.output.MIGDBShowSolibSearchPathInfo;

public class SourceManager
extends SessionObject
implements ICDISourceManager {
    public SourceManager(CSession session) {
        super(session);
    }

    public File[] getDirectories() throws CDIException {
        return null;
    }

    public void reset() throws CDIException {
    }

    public void set(File[] directories) throws CDIException {
    }

    public void addSourcePaths(String[] dirs) throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIEnvironmentDirectory dir = factory.createMIEnvironmentDirectory(dirs);
        try {
            mi.postCommand(dir);
            dir.getMIInfo();
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }

    public String[] getSourcePaths() throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBShowDirectories dir = factory.createMIGDBShowDirectories();
        try {
            mi.postCommand(dir);
            MIGDBShowDirectoriesInfo info = dir.getMIGDBShowDirectoriesInfo();
            return info.getDirectories();
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }

    public void setLibraryPaths(String[] libPaths) throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBSetSolibSearchPath solib = factory.createMIGDBSetSolibSearchPath(libPaths);
        try {
            mi.postCommand(solib);
            solib.getMIInfo();
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }

    public String[] getLibraryPaths() throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBShowSolibSearchPath dir = factory.createMIGDBShowSolibSearchPath();
        try {
            mi.postCommand(dir);
            MIGDBShowSolibSearchPathInfo info = dir.getMIGDBShowSolibSearchPathInfo();
            return info.getDirectories();
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }

    public void setAutoSolib() throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIGDBSetAutoSolib solib = factory.createMIGDBSetAutoSolib(true);
        try {
            mi.postCommand(solib);
            solib.getMIInfo();
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum, int lines) throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataDisassemble dis = factory.createMIDataDisassemble(filename, linenum, lines, false);
        try {
            mi.postCommand(dis);
            MIDataDisassembleInfo info = dis.getMIDataDisassembleInfo();
            MIAsm[] asm = info.getMIAsms();
            ICDIInstruction[] instructions = new Instruction[asm.length];
            int i = 0;
            while (i < instructions.length) {
                instructions[i] = new Instruction(this.getCSession().getCTarget(), asm[i]);
                ++i;
            }
            return instructions;
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }

    public ICDIInstruction[] getInstructions(String filename, int linenum) throws CDIException {
        return this.getInstructions(filename, linenum, -1);
    }

    public ICDIInstruction[] getInstructions(long start, long end) throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        String hex = "0x";
        String sa = hex + Long.toHexString(start);
        String ea = hex + Long.toHexString(end);
        MIDataDisassemble dis = factory.createMIDataDisassemble(sa, ea, false);
        try {
            mi.postCommand(dis);
            MIDataDisassembleInfo info = dis.getMIDataDisassembleInfo();
            MIAsm[] asm = info.getMIAsms();
            ICDIInstruction[] instructions = new Instruction[asm.length];
            int i = 0;
            while (i < instructions.length) {
                instructions[i] = new Instruction(this.getCSession().getCTarget(), asm[i]);
                ++i;
            }
            return instructions;
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }
}

