/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.launch.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class CEnvironmentTab
extends CLaunchConfigurationTab {
    protected Properties fElements;
    private Composite fControl;
    protected TableViewer fVariableList;
    protected Button fBtnNew;
    protected Button fBtnEdit;
    protected Button fBtnRemove;

    public void createControl(Composite parent) {
        this.fElements = new Properties();
        Composite control = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        this.createVerticalSpacer(control, 2);
        control.setLayout((Layout)gl);
        this.createVariableList(control);
        this.createButtons(control);
        this.setControl((Control)control);
        this.fVariableList.setInput((Object)this.fElements);
        this.fVariableList.getTable().setFocus();
        this.updateButtons();
    }

    public void set(String env) {
        ((Hashtable)this.fElements).clear();
        ByteArrayInputStream input = new ByteArrayInputStream(env.getBytes());
        try {
            this.fElements.load(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fVariableList.refresh();
        this.fVariableList.getTable().setFocus();
        if (this.fVariableList.getTable().getItemCount() > 0) {
            this.fVariableList.getTable().setSelection(0);
        }
    }

    public String get() {
        String result = new String();
        Object[] entries = ((Hashtable)this.fElements).entrySet().toArray();
        int i = 0;
        while (i < entries.length) {
            result = result + entries[i].toString() + '\n';
            ++i;
        }
        return result;
    }

    public Properties getProperties() {
        return this.fElements;
    }

    public Object[] toArray() {
        return ((Hashtable)this.fElements).entrySet().toArray();
    }

    private void createVariableList(Composite parent) {
        this.fVariableList = new TableViewer(parent, 2818);
        this.fVariableList.setContentProvider((IContentProvider)new ElementsContentProvider());
        this.fVariableList.setLabelProvider((IBaseLabelProvider)new ElementsLabelProvider());
        this.fVariableList.setSorter((ViewerSorter)new SimpleSorter());
        Table table = this.fVariableList.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        GridData gd = new GridData(272);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText("Name");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText("Value");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        this.fVariableList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                CEnvironmentTab.this.updateButtons();
            }
        });
        this.fVariableList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                CEnvironmentTab.this.elementDoubleClicked((IStructuredSelection)e.getSelection());
            }
        });
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(2));
        composite.setLayout((Layout)new GridLayout(1, true));
        this.fBtnNew = new Button(composite, 0);
        this.fBtnNew.setText("New...");
        this.fBtnNew.setLayoutData((Object)new GridData(1808));
        this.fBtnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CEnvironmentTab.this.newEntry();
            }
        });
        this.fBtnEdit = new Button(composite, 0);
        this.fBtnEdit.setText("Edit...");
        this.fBtnEdit.setLayoutData((Object)new GridData(1808));
        this.fBtnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CEnvironmentTab.this.edit();
            }
        });
        this.fBtnRemove = new Button(composite, 0);
        this.fBtnRemove.setText("Remove");
        this.fBtnRemove.setLayoutData((Object)new GridData(1808));
        this.fBtnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CEnvironmentTab.this.remove();
            }
        });
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fVariableList.getSelection();
        this.fBtnEdit.setEnabled(selection.size() == 1);
        this.fBtnRemove.setEnabled(selection.size() > 0);
    }

    protected void elementDoubleClicked(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return;
        }
        this.doEdit((Map.Entry)selection.getFirstElement());
    }

    protected void newEntry() {
        EntryDialog dialog = new EntryDialog(new String(), new String(), false);
        if (dialog.open() == 0) {
            this.fElements.setProperty(dialog.getName(), dialog.getValue());
            this.fVariableList.refresh();
        }
        this.updateButtons();
    }

    protected void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fVariableList.getSelection();
        this.doEdit((Map.Entry)selection.getFirstElement());
    }

    protected void doEdit(Map.Entry entry) {
        EntryDialog dialog = new EntryDialog(entry.getKey().toString(), entry.getValue().toString(), true);
        if (dialog.open() == 0) {
            ((Hashtable)this.fElements).remove(entry.getKey());
            this.fElements.setProperty(dialog.getName(), dialog.getValue());
            this.fVariableList.refresh();
        }
        this.updateButtons();
    }

    protected void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fVariableList.getSelection();
        Object[] elements = selection.toArray();
        int i = 0;
        while (i < elements.length) {
            ((Hashtable)this.fElements).remove(((Map.Entry)elements[i]).getKey());
            ++i;
        }
        this.fVariableList.refresh();
        this.updateButtons();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ENVIROMENT_MAP, (Map)null);
        config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ENVIROMENT_INHERIT, true);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            Map env = config.getAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ENVIROMENT_MAP, (Map)null);
            if (env != null) {
                ((Hashtable)this.fElements).putAll(env);
                this.fVariableList.refresh();
                this.updateButtons();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ENVIROMENT_MAP, (Map)this.fElements);
        config.setAttribute(ICDTLaunchConfigurationConstants.ATTR_PROGRAM_ENVIROMENT_INHERIT, true);
    }

    public String getName() {
        return "Enviroment";
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_ENVIRONMENT_TAB);
    }

    class EntryDialog
    extends Dialog {
        private String fName;
        private String fValue;
        private boolean fEdit = false;
        private Button fBtnOk = null;
        private Button fBtnCancel = null;
        private Text fTextName = null;
        private Text fTextValue = null;

        public EntryDialog(String name, String value, boolean edit) {
            super(CEnvironmentTab.this.getControl().getShell());
            this.fName = name;
            this.fValue = value;
            this.fEdit = edit;
        }

        protected Control createContents(Composite parent) {
            Control result = super.createContents(parent);
            this.updateButtonsState();
            return result;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            String title = this.fEdit ? "Edit Variable" : "New Variable";
            shell.setText(title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 5;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            GC gc = new GC((Drawable)composite);
            gc.setFont(composite.getFont());
            FontMetrics metrics = gc.getFontMetrics();
            gc.dispose();
            int fieldWidthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)metrics, (int)50);
            Label label = new Label(composite, 0);
            label.setText("Name:");
            this.fTextName = new Text(composite, 2052);
            GridData gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = fieldWidthHint;
            this.fTextName.setLayoutData((Object)gd);
            label = new Label(composite, 0);
            label.setText("Value:");
            this.fTextValue = new Text(composite, 2052);
            gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = fieldWidthHint;
            this.fTextValue.setLayoutData((Object)gd);
            this.fTextName.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ EntryDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.updateButtonsState();
                }
            });
            this.fTextValue.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ EntryDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.updateButtonsState();
                }
            });
            this.fTextName.setText(this.fName);
            this.fTextValue.setText(this.fValue);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.fBtnOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.fBtnCancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void updateButtonsState() {
            if (this.fBtnOk != null) {
                this.fBtnOk.setEnabled(this.fTextName.getText().trim().length() > 0);
            }
        }

        protected String getName() {
            return this.fName;
        }

        protected String getValue() {
            return this.fValue;
        }

        protected void okPressed() {
            this.fName = this.fTextName.getText().trim();
            this.fValue = this.fTextValue.getText().trim();
            this.setReturnCode(0);
            this.close();
        }
    }

    class ElementsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ElementsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof Map.Entry) {
                return columnIndex == 0 ? ((Map.Entry)element).getKey().toString() : ((Map.Entry)element).getValue().toString();
            }
            return null;
        }
    }

    class ElementsContentProvider
    implements IStructuredContentProvider {
        Object input = null;

        ElementsContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((Hashtable)CEnvironmentTab.this.fElements).entrySet().toArray();
        }
    }

    class SimpleSorter
    extends ViewerSorter {
        SimpleSorter() {
        }

        public boolean isSorterProperty(Object element, Object property) {
            return true;
        }
    }
}

