/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import org.eclipse.cdt.internal.errorparsers.ErrorParserManager;
import org.eclipse.cdt.internal.errorparsers.IErrorParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class GCCErrorParser
implements IErrorParser {
    public boolean processLine(String line, ErrorParserManager eoParser) {
        block34: {
            int firstColon;
            block33: {
                firstColon = line.indexOf(58);
                if (firstColon == 1) {
                    try {
                        String os = System.getProperty("os.name");
                        if (os == null || !os.startsWith("Win")) break block33;
                        try {
                            if (Character.isLetter(line.charAt(0))) {
                                firstColon = line.indexOf(58, 2);
                            }
                        }
                        catch (StringIndexOutOfBoundsException e) {}
                    }
                    catch (SecurityException e) {
                        // empty catch block
                    }
                }
            }
            if (firstColon != -1) {
                try {
                    IFile file;
                    int secondColon = line.indexOf(58, firstColon + 1);
                    if (secondColon == -1) break block34;
                    String fileName = line.substring(0, firstColon);
                    String lineNumber = line.substring(firstColon + 1, secondColon);
                    String varName = null;
                    String desc = line.substring(secondColon + 2);
                    int severity = 2;
                    int num = 0;
                    try {
                        num = Integer.parseInt(lineNumber);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (num == 0) {
                        if (fileName.startsWith("cc") || fileName.startsWith("gcc") || fileName.startsWith("qcc") || fileName.startsWith("QCC")) {
                            if (line.indexOf("caught signal") != -1) {
                                return false;
                            }
                        } else {
                            return false;
                        }
                    }
                    if ((file = eoParser.findFilePath(fileName)) != null) {
                        if (desc.startsWith("(Each undeclared")) {
                            return false;
                        }
                        String previous = eoParser.getPreviousLine();
                        if (desc.endsWith(")") && previous.indexOf("(Each undeclared") >= 0) {
                            return false;
                        }
                        int s = desc.indexOf("' undeclared");
                        if (s != -1) {
                            int p = desc.indexOf("`");
                            if (p != -1) {
                                varName = desc.substring(p + 1, s);
                                System.out.println("undex varName " + varName);
                            }
                        } else {
                            s = desc.indexOf("' defined but not used");
                            if (s != -1) {
                                int p = desc.indexOf("`");
                                if (p != -1) {
                                    varName = desc.substring(p + 1, s);
                                    System.out.println("unused varName " + varName);
                                }
                            } else {
                                s = desc.indexOf("conflicting types for `");
                                if (s != -1) {
                                    int p = desc.indexOf("'", s);
                                    if (p != -1) {
                                        varName = desc.substring(desc.indexOf("`") + 1, p);
                                        System.out.println("confl varName " + varName);
                                    }
                                } else {
                                    int p;
                                    s = desc.indexOf("previous declaration of `");
                                    if (s != -1 && (p = desc.indexOf("'", s)) != -1) {
                                        varName = desc.substring(desc.indexOf("`") + 1, p);
                                        System.out.println("prev varName " + varName);
                                    }
                                }
                            }
                        }
                    } else {
                        file = eoParser.findFileName(fileName);
                        if (file != null && eoParser.isConflictingName(fileName)) {
                            desc = "*" + desc;
                            file = null;
                        }
                        if (file == null) {
                            desc = fileName + ": " + desc;
                        }
                    }
                    if (desc.startsWith("warning") || desc.startsWith("Warning")) {
                        severity = 1;
                    }
                    eoParser.generateMarker((IResource)file, num, desc, severity, varName);
                }
                catch (StringIndexOutOfBoundsException e) {
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

