/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core;

import java.util.HashMap;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.internal.core.DebugConfiguration;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;

public class CDebugCorePlugin
extends Plugin {
    public static final int INTERNAL_ERROR = 1000;
    private static CDebugCorePlugin plugin;
    private HashMap fDebugConfigurations;

    public CDebugCorePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static CDebugCorePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getUniqueIdentifier() {
        if (CDebugCorePlugin.getDefault() == null) {
            return "org.eclipse.cdt.debug.core";
        }
        return CDebugCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static void log(Throwable t) {
        DebugException de;
        IStatus status;
        Throwable top = t;
        if (t instanceof DebugException && (status = (de = (DebugException)t).getStatus()).getException() != null) {
            top = status.getException();
        }
        CDebugCorePlugin.log((IStatus)new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 1000, "Internal error logged from CDI Debug: ", top));
    }

    public static void log(IStatus status) {
        CDebugCorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message) {
        CDebugCorePlugin.getDefault().getLog().log((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), 1000, message, null));
    }

    private void initializeDebugConfiguration() {
        IPluginDescriptor descriptor = CDebugCorePlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("CDebugger");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        this.fDebugConfigurations = new HashMap(infos.length);
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            DebugConfiguration configType = new DebugConfiguration(configurationElement);
            this.fDebugConfigurations.put(configType.getID(), configType);
            ++i;
        }
    }

    public ICDebugConfiguration[] getDebugConfigurations() {
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        return this.fDebugConfigurations.values().toArray(new ICDebugConfiguration[0]);
    }

    public ICDebugConfiguration getDebugConfiguration(String id) throws CoreException {
        ICDebugConfiguration dbgCfg;
        if (this.fDebugConfigurations == null) {
            this.initializeDebugConfiguration();
        }
        if ((dbgCfg = (ICDebugConfiguration)this.fDebugConfigurations.get(id)) == null) {
            Status status = new Status(4, CDebugCorePlugin.getUniqueIdentifier(), 100, "No such debugger", null);
            throw new CoreException((IStatus)status);
        }
        return dbgCfg;
    }

    public void shutdown() throws CoreException {
        this.resetBreakpointsInstallCount();
        super.shutdown();
    }

    public void startup() throws CoreException {
        super.startup();
        this.resetBreakpointsInstallCount();
    }

    protected void resetBreakpointsInstallCount() {
        IBreakpointManager bm = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = bm.getBreakpoints(CDebugCorePlugin.getUniqueIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof CBreakpoint) {
                try {
                    ((CBreakpoint)breakpoints[i]).resetInstallCount();
                }
                catch (CoreException e) {
                    CDebugCorePlugin.log(e.getStatus());
                }
            }
            ++i;
        }
    }
}

