/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.ICDebugger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class DebugConfiguration
implements ICDebugConfiguration {
    private IConfigurationElement fElement;
    private HashSet fModes;

    public DebugConfiguration(IConfigurationElement element) {
        this.fElement = element;
    }

    private IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    public ICDebugger getDebugger() throws CoreException {
        return (ICDebugger)this.getConfigurationElement().createExecutableExtension("class");
    }

    public String getName() {
        String name = this.getConfigurationElement().getAttribute("name");
        return name != null ? name : "";
    }

    public String getID() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public String[] getPlatforms() {
        String platform = this.getConfigurationElement().getAttribute("platform");
        if (platform == null) {
            return new String[]{"local"};
        }
        StringTokenizer stoken = new StringTokenizer(platform, ",");
        String[] platforms = new String[stoken.countTokens()];
        int i = 0;
        while (i < platforms.length) {
            platforms[i] = stoken.nextToken();
            ++i;
        }
        return platforms;
    }

    public boolean supportsMode(String mode) {
        return this.getModes().contains(mode);
    }

    protected Set getModes() {
        if (this.fModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return new HashSet(0);
            }
            StringTokenizer tokenizer = new StringTokenizer(modes, ",");
            this.fModes = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fModes.add(tokenizer.nextToken().trim());
            }
        }
        return this.fModes;
    }
}

