/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.internal.core.model.CArrayEntryVariable;
import org.eclipse.cdt.debug.internal.core.model.CArrayPartitionValue;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;

public class CArrayPartition
extends CVariable {
    protected static final int SLOT_SIZE = 100;
    private int fStart;
    private int fEnd;
    private List fCDIVariables;
    private CArrayPartitionValue fArrayPartitionValue = null;

    public CArrayPartition(CDebugElement parent, List cdiVariables, int start, int end) {
        super(parent, null);
        this.fStart = start;
        this.fEnd = end;
        this.fCDIVariables = cdiVariables;
    }

    protected ICDIValue retrieveValue() throws DebugException, CDIException {
        return null;
    }

    public String getName() throws DebugException {
        StringBuffer name = new StringBuffer();
        name.append('[');
        name.append(this.fStart);
        name.append("..");
        name.append(this.fEnd);
        name.append(']');
        return name.toString();
    }

    public String getReferenceTypeName() throws DebugException {
        return null;
    }

    public void handleDebugEvent(ICDIEvent event) {
    }

    public IValue getValue() throws DebugException {
        if (this.fArrayPartitionValue == null) {
            this.fArrayPartitionValue = new CArrayPartitionValue((CDebugTarget)this.getDebugTarget(), this.fCDIVariables, this.getStart(), this.getEnd());
        }
        return this.fArrayPartitionValue;
    }

    public static List splitArray(CDebugTarget target, List cdiVars, int start, int end) {
        ArrayList<CArrayEntryVariable> children = new ArrayList<CArrayEntryVariable>();
        int perSlot = 1;
        int len = end - start;
        while (perSlot * 100 < len) {
            perSlot *= 100;
        }
        while (start <= end) {
            if (start + perSlot > end) {
                perSlot = end - start + 1;
            }
            CVariable var = null;
            var = perSlot == 1 ? new CArrayEntryVariable(target, (ICDIVariable)cdiVars.get(start), start) : new CArrayPartition(target, cdiVars.subList(start, start + perSlot), start, start + perSlot - 1);
            children.add((CArrayEntryVariable)var);
            start += perSlot;
        }
        return children;
    }

    protected int getStart() {
        return this.fStart;
    }

    protected int getEnd() {
        return this.fEnd;
    }
}

