/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.IInstructionStep;
import org.eclipse.cdt.debug.core.IRestart;
import org.eclipse.cdt.debug.core.IState;
import org.eclipse.cdt.debug.core.ISwitchToFrame;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDIEndSteppingRange;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.event.ICDIChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDestroyedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIDisconnectedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDISuspendedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class CThread
extends CDebugElement
implements IThread,
IState,
IRestart,
IInstructionStep,
ISwitchToFrame,
ICDIEventListener {
    private ICDIThread fCDIThread;
    private List fStackFrames;
    private boolean fRunning;
    private boolean fRefreshChildren = true;
    private int fCurrentStateId = 0;
    private Object fCurrentStateInfo = null;
    private ICDIConfiguration fConfig;
    private boolean fIsCurrent = false;
    private CStackFrame fLastStackFrame = null;

    public CThread(CDebugTarget target, ICDIThread cdiThread) {
        super(target);
        this.setCDIThread(cdiThread);
        this.fConfig = this.getCDISession().getConfiguration();
        this.initialize();
        this.getCDISession().getEventManager().addEventListener(this);
    }

    protected void initialize() {
        this.fStackFrames = Collections.EMPTY_LIST;
        this.setRunning(false);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        List list = this.computeStackFrames();
        return list.toArray(new IStackFrame[list.size()]);
    }

    public boolean hasStackFrames() throws DebugException {
        try {
            return this.computeStackFrames().size() > 0;
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    protected synchronized List computeStackFrames(boolean refreshChildren) throws DebugException {
        if (this.isSuspended()) {
            if (this.isTerminated()) {
                this.fStackFrames = Collections.EMPTY_LIST;
            } else if (refreshChildren) {
                if (this.fStackFrames.isEmpty()) {
                    this.fStackFrames = this.createAllStackFrames();
                    this.setRefreshChildren(false);
                    return this.fStackFrames;
                }
                ICDIStackFrame[] frames = this.getCDIStackFrames();
                int offset = 0;
                int length = frames.length;
                if (length > this.fStackFrames.size()) {
                    offset = length - this.fStackFrames.size();
                    int i = offset - 1;
                    while (i >= 0) {
                        this.fStackFrames.add(0, new CStackFrame(this, frames[i]));
                        --i;
                    }
                    length = this.fStackFrames.size() - offset;
                } else if (length < this.fStackFrames.size()) {
                    int removed = this.fStackFrames.size() - length;
                    int i = 0;
                    while (i < removed) {
                        ((CStackFrame)this.fStackFrames.get(0)).dispose();
                        this.fStackFrames.remove(0);
                        ++i;
                    }
                } else if (frames.length == 0) {
                    this.fStackFrames = Collections.EMPTY_LIST;
                } else {
                    ICDIStackFrame newTop = frames[0];
                    ICDIStackFrame oldTop = ((CStackFrame)this.fStackFrames.get(0)).getLastCDIStackFrame();
                    if (!CStackFrame.equalFrame(newTop, oldTop)) {
                        this.disposeStackFrames();
                        this.fStackFrames = new ArrayList(frames.length);
                        int i = 0;
                        while (i < frames.length) {
                            this.fStackFrames.add(new CStackFrame(this, frames[i]));
                            ++i;
                        }
                        offset = this.fStackFrames.size();
                    }
                }
                if (offset < this.fStackFrames.size()) {
                    this.updateStackFrames(frames, offset, this.fStackFrames, length);
                }
            }
            this.setRefreshChildren(false);
        }
        return this.fStackFrames;
    }

    protected ICDIStackFrame[] getCDIStackFrames() throws DebugException {
        try {
            return this.getCDIThread().getStackFrames();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
            return new ICDIStackFrame[0];
        }
    }

    protected void updateStackFrames(ICDIStackFrame[] newFrames, int offset, List oldFrames, int length) throws DebugException {
        int i = 0;
        while (i < length) {
            CStackFrame frame = (CStackFrame)oldFrames.get(offset);
            frame.setCDIStackFrame(newFrames[offset]);
            frame.fireChangeEvent(256);
            ++offset;
            ++i;
        }
    }

    public List computeStackFrames() throws DebugException {
        return this.computeStackFrames(this.refreshChildren());
    }

    public List computeNewStackFrames() throws DebugException {
        return this.computeStackFrames(true);
    }

    protected List createAllStackFrames() throws DebugException {
        ICDIStackFrame[] frames = this.getCDIStackFrames();
        ArrayList<CStackFrame> list = new ArrayList<CStackFrame>(frames.length);
        int i = 0;
        while (i < frames.length) {
            list.add(new CStackFrame(this, frames[i]));
            ++i;
        }
        return list;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        List c = this.computeStackFrames();
        return c.isEmpty() ? null : (IStackFrame)c.get(0);
    }

    public String getName() throws DebugException {
        return this.getCDIThread().toString();
    }

    public IBreakpoint[] getBreakpoints() {
        return null;
    }

    public void handleDebugEvent(ICDIEvent event) {
        ICDIObject source = event.getSource();
        if (source == null) {
            return;
        }
        if (source.getTarget().equals(this.getCDITarget())) {
            if (event instanceof ICDISuspendedEvent) {
                if (source instanceof ICDIThread && this.getCDIThread().equals((ICDIThread)source) || source instanceof ICDITarget) {
                    this.handleSuspendedEvent((ICDISuspendedEvent)event);
                }
            } else if (event instanceof ICDIResumedEvent) {
                if (source instanceof ICDIThread && source.equals(this.getCDIThread()) || source instanceof ICDITarget) {
                    this.handleResumedEvent((ICDIResumedEvent)event);
                }
            } else if (event instanceof ICDIDestroyedEvent) {
                if (source instanceof ICDIThread) {
                    this.handleTerminatedEvent((ICDIDestroyedEvent)event);
                }
            } else if (event instanceof ICDIDisconnectedEvent) {
                if (source instanceof ICDIThread) {
                    this.handleDisconnectedEvent((ICDIDisconnectedEvent)event);
                }
            } else if (event instanceof ICDIChangedEvent && source instanceof ICDIThread) {
                this.handleChangedEvent((ICDIChangedEvent)event);
            }
        }
    }

    public boolean canResume() {
        return this.fConfig.supportsResume() && this.isSuspended();
    }

    public boolean canSuspend() {
        return this.fConfig.supportsSuspend() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return !this.fRunning && !this.isTerminated();
    }

    public void resume() throws DebugException {
        if (!this.isSuspended()) {
            return;
        }
        try {
            this.getCDIThread().resume();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public void suspend() throws DebugException {
        if (this.isSuspended()) {
            return;
        }
        try {
            this.getCDIThread().suspend();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public boolean canStepReturn() {
        return this.canStep();
    }

    protected boolean canStep() {
        try {
            return this.fConfig.supportsStepping() && this.isSuspended() && this.getTopStackFrame() != null;
        }
        catch (DebugException e) {
            return false;
        }
    }

    public boolean isStepping() {
        return this.getCurrentStateId() == 6;
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        try {
            if (this.getRealSourceMode() == 0) {
                this.getCDIThread().stepInto();
            } else {
                this.getCDIThread().stepIntoInstruction();
            }
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver()) {
            return;
        }
        try {
            if (this.getRealSourceMode() == 0) {
                this.getCDIThread().stepOver();
            } else {
                this.getCDIThread().stepOverInstruction();
            }
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn()) {
            return;
        }
        try {
            this.getCDIThread().stepReturn();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public boolean canTerminate() {
        return this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void setCDIThread(ICDIThread cdiThread) {
        this.fCDIThread = cdiThread;
    }

    protected ICDIThread getCDIThread() {
        return this.fCDIThread;
    }

    protected void setRunning(boolean running) {
        this.fRunning = running;
    }

    protected synchronized void preserveStackFrames() {
        Iterator it = this.fStackFrames.iterator();
        while (it.hasNext()) {
            ((CStackFrame)it.next()).preserve();
        }
        this.setRefreshChildren(true);
    }

    protected synchronized void disposeStackFrames() {
        Iterator it = this.fStackFrames.iterator();
        while (it.hasNext()) {
            ((CStackFrame)it.next()).dispose();
        }
        this.fStackFrames.clear();
        this.setRefreshChildren(true);
    }

    protected void terminated() {
        this.setRunning(false);
        this.cleanup();
        this.fireTerminateEvent();
    }

    public int getCurrentStateId() {
        return this.fCurrentStateId;
    }

    private void setCurrentStateId(int id) {
        this.fCurrentStateId = id;
    }

    public Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    private void setCurrentStateInfo(Object info) {
        this.fCurrentStateInfo = info;
    }

    public boolean canStepIntoInstruction() {
        return this.canStepInto();
    }

    public boolean canStepOverInstruction() {
        return this.canStepOver();
    }

    public void stepIntoInstruction() throws DebugException {
        if (!this.canStepIntoInstruction()) {
            return;
        }
        try {
            this.getCDIThread().stepIntoInstruction();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    public void stepOverInstruction() throws DebugException {
        if (!this.canStepOverInstruction()) {
            return;
        }
        try {
            this.getCDIThread().stepOverInstruction();
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.toString(), e);
        }
    }

    private void handleSuspendedEvent(ICDISuspendedEvent event) {
        this.setRunning(false);
        if (event.getSource() instanceof ICDITarget) {
            if (this.isCurrent()) {
                this.setCurrentStateId(7);
                ICDISessionObject reason = event.getReason();
                this.setCurrentStateInfo(reason);
                if (reason instanceof ICDIEndSteppingRange) {
                    this.handleEndSteppingRange((ICDIEndSteppingRange)reason);
                } else if (reason instanceof ICDIBreakpoint) {
                    this.handleBreakpointHit((ICDIBreakpoint)((Object)reason));
                } else if (reason instanceof ICDISignal) {
                    this.handleSuspendedBySignal((ICDISignal)reason);
                } else {
                    this.fireSuspendEvent(32);
                }
            }
            return;
        }
        this.setCurrentStateId(7);
        this.setCurrentStateInfo(null);
    }

    private void handleResumedEvent(ICDIResumedEvent event) {
        this.setRunning(true);
        this.setLastStackFrame(null);
        int state = 5;
        int detail = 0;
        if (this.isCurrent()) {
            switch (event.getType()) {
                case 0: {
                    detail = 32;
                    state = 5;
                    this.disposeStackFrames();
                    break;
                }
                case 2: 
                case 4: {
                    detail = 1;
                    state = 6;
                    this.preserveStackFrames();
                    break;
                }
                case 1: 
                case 3: {
                    detail = 2;
                    state = 6;
                    this.preserveStackFrames();
                    break;
                }
                case 5: {
                    detail = 4;
                    state = 6;
                    this.preserveStackFrames();
                }
            }
        } else {
            this.disposeStackFrames();
            detail = 32;
        }
        this.setCurrentStateId(state);
        this.setCurrentStateInfo(null);
        this.fireResumeEvent(detail);
    }

    private void handleEndSteppingRange(ICDIEndSteppingRange endSteppingRange) {
        this.fireSuspendEvent(8);
    }

    private void handleBreakpointHit(ICDIBreakpoint breakpoint) {
        this.fireSuspendEvent(16);
    }

    private void handleSuspendedBySignal(ICDISignal signal) {
        this.fireSuspendEvent(0);
    }

    private void handleTerminatedEvent(ICDIDestroyedEvent event) {
    }

    private void handleDisconnectedEvent(ICDIDisconnectedEvent event) {
        this.setCurrentStateId(10);
        this.setCurrentStateInfo(null);
        this.terminated();
    }

    private void handleChangedEvent(ICDIChangedEvent event) {
    }

    protected void cleanup() {
        this.getCDISession().getEventManager().removeEventListener(this);
        this.disposeStackFrames();
    }

    protected synchronized void stepToFrame(IStackFrame frame) throws DebugException {
    }

    private void setRefreshChildren(boolean refresh) {
        this.fRefreshChildren = refresh;
    }

    private boolean refreshChildren() {
        return this.fRefreshChildren;
    }

    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && ((IRestart)this.getDebugTarget()).canRestart();
    }

    public void restart() throws DebugException {
        if (this.canRestart()) {
            ((IRestart)this.getDebugTarget()).restart();
        }
    }

    protected boolean isCurrent() {
        return this.fIsCurrent;
    }

    protected void setCurrent(boolean current) {
        this.fIsCurrent = current;
    }

    public void switchToFrame(IStackFrame frame) throws DebugException {
        if (frame == null || !(frame instanceof CStackFrame) || frame.equals(this.getLastStackFrame())) {
            return;
        }
        try {
            if (this.getLastStackFrame() != null) {
                this.getCDIThread().setCurrentStackFrame(((CStackFrame)frame).getCDIStackFrame());
            }
            this.setLastStackFrame((CStackFrame)frame);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    private int getRealSourceMode() {
        return ((CDebugTarget)this.getDebugTarget()).getRealSourceMode();
    }

    private void setLastStackFrame(CStackFrame frame) {
        this.fLastStackFrame = frame;
    }

    private CStackFrame getLastStackFrame() {
        return this.fLastStackFrame;
    }
}

