/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import java.io.File;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CDirectorySourceLocation
implements ICSourceLocation {
    private IPath fDirectory;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation;
    static /* synthetic */ Class class$org$eclipse$cdt$debug$internal$core$sourcelookup$CDirectorySourceLocation;

    public CDirectorySourceLocation(IPath directory) {
        this.setDirectory(directory);
    }

    public Object findSourceElement(String name) throws CoreException {
        if (this.getDirectory() != null) {
            File file = new File(name);
            if (file.isAbsolute()) {
                return this.findFileByAbsolutePath(name);
            }
            return this.findFileByRelativePath(name);
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation == null ? (class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation = CDirectorySourceLocation.class$("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation")) : class$org$eclipse$cdt$debug$core$sourcelookup$ICSourceLocation)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$cdt$debug$internal$core$sourcelookup$CDirectorySourceLocation == null ? (class$org$eclipse$cdt$debug$internal$core$sourcelookup$CDirectorySourceLocation = CDirectorySourceLocation.class$("org.eclipse.cdt.debug.internal.core.sourcelookup.CDirectorySourceLocation")) : class$org$eclipse$cdt$debug$internal$core$sourcelookup$CDirectorySourceLocation)) {
            return this;
        }
        return null;
    }

    private void setDirectory(IPath directory) {
        this.fDirectory = directory;
    }

    public IPath getDirectory() {
        return this.fDirectory;
    }

    private Object findFileByAbsolutePath(String fileName) {
        Path filePath = new Path(fileName);
        String name = filePath.lastSegment();
        filePath = filePath.removeLastSegments(1);
        IPath path = this.getDirectory();
        if (path.equals((Object)filePath)) {
            path = path.append(name);
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            if (f != null) {
                return f;
            }
            File file = path.toFile();
            if (file.exists()) {
                return this.createExternalFileStorage(path);
            }
        }
        return null;
    }

    private Object findFileByRelativePath(String fileName) {
        IPath path = this.getDirectory();
        if (path != null) {
            path = path.append(fileName);
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
            if (f != null) {
                return f;
            }
            File file = path.toFile();
            if (file.exists()) {
                return this.createExternalFileStorage(path);
            }
        }
        return null;
    }

    private IStorage createExternalFileStorage(IPath path) {
        return new FileStorage(path);
    }

    public IPath[] getPaths() {
        return new IPath[]{this.fDirectory};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

