/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import org.eclipse.cdt.debug.core.IStackFrameInfo;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.ISourceMode;
import org.eclipse.cdt.debug.internal.core.sourcelookup.DisassemblyManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;

public class CSourceManager
implements ICSourceLocator,
ISourceMode,
IAdaptable {
    private ISourceLocator fSourceLocator;
    private DisassemblyManager fDisassemblyManager;
    private int fMode;
    private int fRealMode;

    public CSourceManager(ISourceLocator sourceLocator, DisassemblyManager disassemblyManager) {
        this.fRealMode = this.fMode = 0;
        this.setSourceLocator(sourceLocator);
        this.setDisassemblyManager(disassemblyManager);
    }

    public int getLineNumber(IStackFrameInfo frameInfo) {
        if (this.getRealMode() == 0) {
            if (this.getCSourceLocator() != null) {
                return this.getCSourceLocator().getLineNumber(frameInfo);
            }
            if (frameInfo != null) {
                return frameInfo.getFrameLineNumber();
            }
        }
        if (this.getRealMode() == 1 && this.getDisassemblyManager() != null) {
            return this.getDisassemblyManager().getLineNumber(frameInfo);
        }
        return 0;
    }

    public ICSourceLocation[] getSourceLocations() {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().getSourceLocations() : new ICSourceLocation[]{};
    }

    public void setSourceLocations(ICSourceLocation[] locations) {
        if (this.getCSourceLocator() != null) {
            this.getCSourceLocator().setSourceLocations(locations);
        }
    }

    public boolean contains(IResource resource) {
        return this.getCSourceLocator() != null ? this.getCSourceLocator().contains(resource) : false;
    }

    public int getMode() {
        return this.fMode;
    }

    public void setMode(int mode) {
        this.fMode = mode;
    }

    public int getRealMode() {
        return this.fRealMode;
    }

    protected void setRealMode(int mode) {
        this.fRealMode = mode;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Object result = null;
        if (this.getMode() == 0 && this.getSourceLocator() != null) {
            result = this.getSourceLocator().getSourceElement(stackFrame);
        }
        if (result == null && this.getDisassemblyManager() != null) {
            this.setRealMode(1);
            result = this.getDisassemblyManager().getSourceElement(stackFrame);
        } else {
            this.setRealMode(0);
        }
        return result;
    }

    protected ICSourceLocator getCSourceLocator() {
        if (this.getSourceLocator() instanceof ICSourceLocator) {
            return (ICSourceLocator)this.getSourceLocator();
        }
        return null;
    }

    protected ISourceLocator getSourceLocator() {
        return this.fSourceLocator;
    }

    protected void setSourceLocator(ISourceLocator sl) {
        this.fSourceLocator = sl;
    }

    protected void setDisassemblyManager(DisassemblyManager dm) {
        this.fDisassemblyManager = dm;
    }

    protected DisassemblyManager getDisassemblyManager() {
        return this.fDisassemblyManager;
    }
}

