/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Observable;
import org.eclipse.cdt.debug.mi.core.CommandQueue;
import org.eclipse.cdt.debug.mi.core.EventThread;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.Queue;
import org.eclipse.cdt.debug.mi.core.RxThread;
import org.eclipse.cdt.debug.mi.core.TxThread;
import org.eclipse.cdt.debug.mi.core.command.Command;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBExit;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIGDBExitEvent;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIParser;
import org.eclipse.cdt.utils.pty.PTY;

public class MISession
extends Observable {
    public static final int PROGRAM = 0;
    public static final int ATTACH = 1;
    public static final int CORE = 2;
    public static long REQUEST_TIMEOUT = 10000L;
    boolean terminated;
    int sessionType;
    Process miProcess;
    InputStream inChannel;
    OutputStream outChannel;
    TxThread txThread;
    RxThread rxThread;
    EventThread eventThread;
    CommandQueue txQueue;
    CommandQueue rxQueue;
    Queue eventQueue;
    PipedInputStream miInPipe;
    PipedOutputStream miOutPipe;
    CommandFactory factory;
    MIParser parser;
    long cmdTimeout;
    MIInferior inferior;
    static int number = 1;

    public MISession(Process process, PTY pty, int timeout, int type) throws MIException {
        this.miProcess = process;
        this.inChannel = process.getInputStream();
        this.outChannel = process.getOutputStream();
        this.cmdTimeout = timeout;
        this.sessionType = type;
        this.factory = new CommandFactory();
        this.parser = new MIParser();
        this.inferior = new MIInferior(this, pty);
        this.txQueue = new CommandQueue();
        this.rxQueue = new CommandQueue();
        this.eventQueue = new Queue();
        this.txThread = new TxThread(this);
        this.rxThread = new RxThread(this);
        this.eventThread = new EventThread(this);
        this.txThread.start();
        this.rxThread.start();
        this.eventThread.start();
        MIGDBSet confirm = new MIGDBSet(new String[]{"confirm", "off"});
        this.postCommand(confirm);
        confirm.getMIInfo();
        MIGDBSet width = new MIGDBSet(new String[]{"width", "0"});
        this.postCommand(width);
        confirm.getMIInfo();
        MIGDBSet height = new MIGDBSet(new String[]{"height", "0"});
        this.postCommand(height);
        confirm.getMIInfo();
    }

    public InputStream getMIStream() {
        if (this.miInPipe == null) {
            try {
                this.miOutPipe = new PipedOutputStream();
                this.miInPipe = new PipedInputStream(this.miOutPipe);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.miInPipe;
    }

    public CommandFactory getCommandFactory() {
        return this.factory;
    }

    public void setCommandFactory(CommandFactory f) {
        this.factory = f;
    }

    public MIParser getMIParser() {
        return this.parser;
    }

    public void setMIParser(MIParser p) {
        this.parser = p;
    }

    public int getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(int type) {
        this.sessionType = type;
    }

    public boolean isProgramSession() {
        return this.sessionType == 0;
    }

    public boolean isAttachSession() {
        return this.sessionType == 1;
    }

    public boolean isCoreSession() {
        return this.sessionType == 2;
    }

    public void setCommandTimeout(long timeout) {
        this.cmdTimeout = timeout;
    }

    public long getCommandTimeout() {
        return this.cmdTimeout;
    }

    public void postCommand(Command cmd) throws MIException {
        this.postCommand(cmd, this.cmdTimeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void postCommand(Command cmd, long timeout) throws MIException {
        if (!this.txThread.isAlive()) throw new MIException("{R,T}xThread terminated");
        if (!this.rxThread.isAlive()) {
            throw new MIException("{R,T}xThread terminated");
        }
        if (this.inferior.isRunning()) {
            throw new MIException("Target running");
        }
        this.txQueue.addCommand(cmd);
        Command command = cmd;
        synchronized (command) {
            while (cmd.getMIOutput() == null) {
                try {
                    cmd.wait(timeout);
                    if (cmd.getMIOutput() != null) continue;
                    throw new MIException("Timedout");
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public MIInferior getMIInferior() {
        return this.inferior;
    }

    public Process getMIProcess() {
        return this.miProcess;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() {
        if (this.isTerminated()) {
            return;
        }
        this.terminated = true;
        this.inferior.destroy();
        this.notifyObservers(new MIGDBExitEvent());
        InputStream inGDB = this.inChannel;
        this.inChannel = null;
        OutputStream outGDB = this.outChannel;
        this.outChannel = null;
        try {
            MIGDBExit exit = this.factory.createMIGDBExit();
            this.postCommand(exit);
        }
        catch (MIException e) {
            // empty catch block
        }
        if (this.miProcess != null) {
            this.miProcess.destroy();
        }
        try {
            if (inGDB != null) {
                inGDB.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (outGDB != null) {
                outGDB.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.miInPipe = null;
            if (this.miOutPipe != null) {
                this.miOutPipe.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.txThread.isAlive()) {
                this.txThread.interrupt();
                this.txThread.join(this.cmdTimeout);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            if (this.rxThread.isAlive()) {
                this.rxThread.interrupt();
                this.rxThread.join(this.cmdTimeout);
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            if (this.eventThread.isAlive()) {
                this.eventThread.interrupt();
                this.eventThread.join(this.cmdTimeout);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    OutputStream getConsolePipe() {
        return this.miOutPipe;
    }

    CommandQueue getTxQueue() {
        return this.txQueue;
    }

    CommandQueue getRxQueue() {
        return this.rxQueue;
    }

    Queue getEventQueue() {
        return this.eventQueue;
    }

    RxThread getRxThread() {
        return this.rxThread;
    }

    InputStream getChannelInputStream() {
        return this.inChannel;
    }

    OutputStream getChannelOutputStream() {
        return this.outChannel;
    }

    MIOutput parse(String buffer) {
        return this.parser.parse(buffer);
    }

    public void fireEvents(MIEvent[] events) {
        if (events != null && events.length > 0) {
            int i = 0;
            while (i < events.length) {
                this.fireEvent(events[i]);
                ++i;
            }
        }
    }

    public void fireEvent(MIEvent event) {
        if (event != null) {
            this.getEventQueue().addItem(event);
        }
    }
}

