/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import org.eclipse.cdt.debug.core.cdi.ICDIConfiguration;
import org.eclipse.cdt.debug.mi.core.MIInferior;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.utils.spawner.Spawner;

public class Configuration
implements ICDIConfiguration {
    protected boolean fAttached;
    MISession miSession;

    public Configuration(MISession s, boolean attached) {
        this.fAttached = attached;
        this.miSession = s;
    }

    public boolean supportsBreakpoints() {
        return true;
    }

    public boolean supportsDisconnect() {
        return this.fAttached;
    }

    public boolean supportsExpressionEvaluation() {
        return true;
    }

    public boolean supportsInstructionStepping() {
        return true;
    }

    public boolean supportsMemoryModification() {
        return true;
    }

    public boolean supportsMemoryRetrieval() {
        return true;
    }

    public boolean supportsRegisterModification() {
        return true;
    }

    public boolean supportsRegisters() {
        return true;
    }

    public boolean supportsRestart() {
        return !this.fAttached;
    }

    public boolean supportsStepping() {
        return true;
    }

    public boolean supportsTerminate() {
        return !this.fAttached;
    }

    public boolean supportsResume() {
        return true;
    }

    public boolean supportsSuspend() {
        String os = null;
        try {
            os = System.getProperty("os.name", "");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        Process gdb = this.miSession.getMIProcess();
        if (gdb instanceof Spawner) {
            if (this.fAttached) {
                return true;
            }
            MIInferior inferior = this.miSession.getMIInferior();
            if (inferior.getPTY() != null) {
                return !os.equals("SunOS");
            }
        }
        return false;
    }
}

