/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.CTarget;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.debug.mi.core.output.MIMemory;

public class MemoryBlock
extends CObject
implements ICDIMemoryBlock {
    MIDataReadMemoryInfo mem;
    boolean frozen;

    public MemoryBlock(CTarget target, MIDataReadMemoryInfo info) {
        super(target);
        this.mem = info;
        this.frozen = true;
    }

    public byte[] getBytes() throws CDIException {
        MIMemory[] miMem = this.mem.getMemories();
        ArrayList<Long> aList = new ArrayList<Long>();
        int i = 0;
        while (i < miMem.length) {
            long[] data = miMem[i].getData();
            int j = 0;
            while (j < data.length) {
                aList.add(new Long(data[j]));
                ++j;
            }
            ++i;
        }
        byte[] bytes = new byte[aList.size()];
        int i2 = 0;
        while (i2 < aList.size()) {
            Long l = (Long)aList.get(i2);
            bytes[i2] = l.byteValue();
            ++i2;
        }
        return bytes;
    }

    public long getLength() {
        return this.mem.getTotalBytes();
    }

    public long getStartAddress() {
        return this.mem.getAddress();
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public void setValue(long offset, byte[] bytes) throws CDIException {
        throw new CDIException("Not supported");
    }
}

