/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIMemoryManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDIMemoryBlock;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CSession;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataReadMemory;
import org.eclipse.cdt.debug.mi.core.output.MIDataReadMemoryInfo;

public class MemoryManager
extends SessionObject
implements ICDIMemoryManager {
    List blockList = new ArrayList();

    public MemoryManager(CSession session) {
        super(session);
    }

    public ICDIMemoryBlock createMemoryBlock(long address, int length) throws CDIException {
        String addr = "0x" + Long.toHexString(address);
        return this.createMemoryBlock(addr, length);
    }

    public ICDIMemoryBlock createMemoryBlock(String address, int length) throws CDIException {
        MISession mi = this.getCSession().getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataReadMemory mem = factory.createMIDataReadMemory(0L, address, 0, 1, 1, length, null);
        try {
            mi.postCommand(mem);
            MIDataReadMemoryInfo info = mem.getMIDataReadMemoryInfo();
            MemoryBlock block = new MemoryBlock(this.getCSession().getCTarget(), info);
            this.blockList.add(block);
            return block;
        }
        catch (MIException e) {
            throw new CDIException(e.getMessage());
        }
    }

    public ICDIMemoryBlock[] getMemoryBlocks() throws CDIException {
        return this.blockList.toArray(new ICDIMemoryBlock[0]);
    }

    public void removeAllBlocks() throws CDIException {
        this.blockList.clear();
    }

    public void removeBlock(ICDIMemoryBlock memoryBlock) throws CDIException {
        this.blockList.remove(memoryBlock);
    }

    public void removeBlocks(ICDIMemoryBlock[] memoryBlocks) throws CDIException {
        int i = 0;
        while (i < memoryBlocks.length) {
            this.removeBlock(memoryBlocks[i]);
            ++i;
        }
    }
}

