/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.event;

import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIConst;
import org.eclipse.cdt.debug.mi.core.output.MIExecAsyncOutput;
import org.eclipse.cdt.debug.mi.core.output.MIFrame;
import org.eclipse.cdt.debug.mi.core.output.MIResult;
import org.eclipse.cdt.debug.mi.core.output.MIResultRecord;
import org.eclipse.cdt.debug.mi.core.output.MITuple;
import org.eclipse.cdt.debug.mi.core.output.MIValue;

public class MIWatchpointScopeEvent
extends MIStoppedEvent {
    int number;
    int threadId;
    MIFrame frame;
    MIExecAsyncOutput exec;
    MIResultRecord rr;

    public MIWatchpointScopeEvent(MIExecAsyncOutput record) {
        this.exec = record;
        this.parse();
    }

    public MIWatchpointScopeEvent(MIResultRecord record) {
        this.rr = record;
        this.parse();
    }

    public int getNumber() {
        return this.number;
    }

    public int getThreadId() {
        return this.threadId;
    }

    public MIFrame getFrame() {
        return this.frame;
    }

    void parse() {
        MIResult[] results = null;
        if (this.exec != null) {
            results = this.exec.getMIResults();
        } else if (this.rr != null) {
            results = this.rr.getMIResults();
        }
        if (results != null) {
            int i = 0;
            while (i < results.length) {
                String str;
                String var = results[i].getVariable();
                MIValue value = results[i].getMIValue();
                if (var.equals("wpnum")) {
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getString();
                        try {
                            this.number = Integer.parseInt(str.trim());
                        }
                        catch (NumberFormatException e) {}
                    }
                } else if (var.equals("thread-id")) {
                    if (value instanceof MIConst) {
                        str = ((MIConst)value).getString();
                        try {
                            this.threadId = Integer.parseInt(str.trim());
                        }
                        catch (NumberFormatException e) {}
                    }
                } else if (var.equals("frame") && value instanceof MITuple) {
                    this.frame = new MIFrame((MITuple)value);
                }
                ++i;
            }
        }
    }
}

